/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse;

public final class DescribeClusterSubnetGroupsPaginator
implements SdkIterable<DescribeClusterSubnetGroupsResponse> {
    private final RedshiftClient client;
    private final DescribeClusterSubnetGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeClusterSubnetGroupsPaginator(RedshiftClient client, DescribeClusterSubnetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterSubnetGroupsResponseFetcher();
    }

    public Iterator<DescribeClusterSubnetGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ClusterSubnetGroup> clusterSubnetGroups() {
        Function<DescribeClusterSubnetGroupsResponse, Iterator> getIterator = response -> response != null ? response.clusterSubnetGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeClusterSubnetGroupsResponseFetcher
    implements NextPageFetcher<DescribeClusterSubnetGroupsResponse> {
        private DescribeClusterSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterSubnetGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeClusterSubnetGroupsResponse nextPage(DescribeClusterSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterSubnetGroupsPaginator.this.client.describeClusterSubnetGroups(DescribeClusterSubnetGroupsPaginator.this.firstRequest);
            }
            return DescribeClusterSubnetGroupsPaginator.this.client.describeClusterSubnetGroups((DescribeClusterSubnetGroupsRequest)((Object)DescribeClusterSubnetGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

