/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.Snapshot;

public final class DescribeClusterSnapshotsPaginator
implements SdkIterable<DescribeClusterSnapshotsResponse> {
    private final RedshiftClient client;
    private final DescribeClusterSnapshotsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeClusterSnapshotsPaginator(RedshiftClient client, DescribeClusterSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterSnapshotsResponseFetcher();
    }

    public Iterator<DescribeClusterSnapshotsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Snapshot> snapshots() {
        Function<DescribeClusterSnapshotsResponse, Iterator> getIterator = response -> response != null ? response.snapshots().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeClusterSnapshotsResponseFetcher
    implements NextPageFetcher<DescribeClusterSnapshotsResponse> {
        private DescribeClusterSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterSnapshotsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeClusterSnapshotsResponse nextPage(DescribeClusterSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterSnapshotsPaginator.this.client.describeClusterSnapshots(DescribeClusterSnapshotsPaginator.this.firstRequest);
            }
            return DescribeClusterSnapshotsPaginator.this.client.describeClusterSnapshots((DescribeClusterSnapshotsRequest)((Object)DescribeClusterSnapshotsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

