/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RestoreStatus
implements ToCopyableBuilder<Builder, RestoreStatus> {
    private final String status;
    private final Double currentRestoreRateInMegaBytesPerSecond;
    private final Long snapshotSizeInMegaBytes;
    private final Long progressInMegaBytes;
    private final Long elapsedTimeInSeconds;
    private final Long estimatedTimeToCompletionInSeconds;

    private RestoreStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.currentRestoreRateInMegaBytesPerSecond = builder.currentRestoreRateInMegaBytesPerSecond;
        this.snapshotSizeInMegaBytes = builder.snapshotSizeInMegaBytes;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.estimatedTimeToCompletionInSeconds = builder.estimatedTimeToCompletionInSeconds;
    }

    public String status() {
        return this.status;
    }

    public Double currentRestoreRateInMegaBytesPerSecond() {
        return this.currentRestoreRateInMegaBytesPerSecond;
    }

    public Long snapshotSizeInMegaBytes() {
        return this.snapshotSizeInMegaBytes;
    }

    public Long progressInMegaBytes() {
        return this.progressInMegaBytes;
    }

    public Long elapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds;
    }

    public Long estimatedTimeToCompletionInSeconds() {
        return this.estimatedTimeToCompletionInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRestoreRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.elapsedTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeToCompletionInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreStatus)) {
            return false;
        }
        RestoreStatus other = (RestoreStatus)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.currentRestoreRateInMegaBytesPerSecond(), other.currentRestoreRateInMegaBytesPerSecond()) && Objects.equals(this.snapshotSizeInMegaBytes(), other.snapshotSizeInMegaBytes()) && Objects.equals(this.progressInMegaBytes(), other.progressInMegaBytes()) && Objects.equals(this.elapsedTimeInSeconds(), other.elapsedTimeInSeconds()) && Objects.equals(this.estimatedTimeToCompletionInSeconds(), other.estimatedTimeToCompletionInSeconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.currentRestoreRateInMegaBytesPerSecond() != null) {
            sb.append("CurrentRestoreRateInMegaBytesPerSecond: ").append(this.currentRestoreRateInMegaBytesPerSecond()).append(",");
        }
        if (this.snapshotSizeInMegaBytes() != null) {
            sb.append("SnapshotSizeInMegaBytes: ").append(this.snapshotSizeInMegaBytes()).append(",");
        }
        if (this.progressInMegaBytes() != null) {
            sb.append("ProgressInMegaBytes: ").append(this.progressInMegaBytes()).append(",");
        }
        if (this.elapsedTimeInSeconds() != null) {
            sb.append("ElapsedTimeInSeconds: ").append(this.elapsedTimeInSeconds()).append(",");
        }
        if (this.estimatedTimeToCompletionInSeconds() != null) {
            sb.append("EstimatedTimeToCompletionInSeconds: ").append(this.estimatedTimeToCompletionInSeconds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "CurrentRestoreRateInMegaBytesPerSecond": {
                return Optional.of(clazz.cast(this.currentRestoreRateInMegaBytesPerSecond()));
            }
            case "SnapshotSizeInMegaBytes": {
                return Optional.of(clazz.cast(this.snapshotSizeInMegaBytes()));
            }
            case "ProgressInMegaBytes": {
                return Optional.of(clazz.cast(this.progressInMegaBytes()));
            }
            case "ElapsedTimeInSeconds": {
                return Optional.of(clazz.cast(this.elapsedTimeInSeconds()));
            }
            case "EstimatedTimeToCompletionInSeconds": {
                return Optional.of(clazz.cast(this.estimatedTimeToCompletionInSeconds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Double currentRestoreRateInMegaBytesPerSecond;
        private Long snapshotSizeInMegaBytes;
        private Long progressInMegaBytes;
        private Long elapsedTimeInSeconds;
        private Long estimatedTimeToCompletionInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreStatus model) {
            this.status(model.status);
            this.currentRestoreRateInMegaBytesPerSecond(model.currentRestoreRateInMegaBytesPerSecond);
            this.snapshotSizeInMegaBytes(model.snapshotSizeInMegaBytes);
            this.progressInMegaBytes(model.progressInMegaBytes);
            this.elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            this.estimatedTimeToCompletionInSeconds(model.estimatedTimeToCompletionInSeconds);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Double getCurrentRestoreRateInMegaBytesPerSecond() {
            return this.currentRestoreRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder currentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond) {
            this.currentRestoreRateInMegaBytesPerSecond = currentRestoreRateInMegaBytesPerSecond;
            return this;
        }

        public final void setCurrentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond) {
            this.currentRestoreRateInMegaBytesPerSecond = currentRestoreRateInMegaBytesPerSecond;
        }

        public final Long getSnapshotSizeInMegaBytes() {
            return this.snapshotSizeInMegaBytes;
        }

        @Override
        public final Builder snapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes) {
            this.snapshotSizeInMegaBytes = snapshotSizeInMegaBytes;
            return this;
        }

        public final void setSnapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes) {
            this.snapshotSizeInMegaBytes = snapshotSizeInMegaBytes;
        }

        public final Long getProgressInMegaBytes() {
            return this.progressInMegaBytes;
        }

        @Override
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        public final Long getElapsedTimeInSeconds() {
            return this.elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        public final Long getEstimatedTimeToCompletionInSeconds() {
            return this.estimatedTimeToCompletionInSeconds;
        }

        @Override
        public final Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
            return this;
        }

        public final void setEstimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
        }

        public RestoreStatus build() {
            return new RestoreStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RestoreStatus> {
        public Builder status(String var1);

        public Builder currentRestoreRateInMegaBytesPerSecond(Double var1);

        public Builder snapshotSizeInMegaBytes(Long var1);

        public Builder progressInMegaBytes(Long var1);

        public Builder elapsedTimeInSeconds(Long var1);

        public Builder estimatedTimeToCompletionInSeconds(Long var1);
    }
}

