/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetClusterCredentialsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetClusterCredentialsResponse> {
    private final String dbUser;
    private final String dbPassword;
    private final Instant expiration;

    private GetClusterCredentialsResponse(BuilderImpl builder) {
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
        this.expiration = builder.expiration;
    }

    public String dbUser() {
        return this.dbUser;
    }

    public String dbPassword() {
        return this.dbPassword;
    }

    public Instant expiration() {
        return this.expiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterCredentialsResponse)) {
            return false;
        }
        GetClusterCredentialsResponse other = (GetClusterCredentialsResponse)((Object)obj);
        return Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.dbPassword(), other.dbPassword()) && Objects.equals(this.expiration(), other.expiration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbUser() != null) {
            sb.append("DbUser: ").append(this.dbUser()).append(",");
        }
        if (this.dbPassword() != null) {
            sb.append("DbPassword: ").append(this.dbPassword()).append(",");
        }
        if (this.expiration() != null) {
            sb.append("Expiration: ").append(this.expiration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DbUser": {
                return Optional.of(clazz.cast(this.dbUser()));
            }
            case "DbPassword": {
                return Optional.of(clazz.cast(this.dbPassword()));
            }
            case "Expiration": {
                return Optional.of(clazz.cast(this.expiration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbUser;
        private String dbPassword;
        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterCredentialsResponse model) {
            this.dbUser(model.dbUser);
            this.dbPassword(model.dbPassword);
            this.expiration(model.expiration);
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getDbPassword() {
            return this.dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        public GetClusterCredentialsResponse build() {
            return new GetClusterCredentialsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetClusterCredentialsResponse> {
        public Builder dbUser(String var1);

        public Builder dbPassword(String var1);

        public Builder expiration(Instant var1);
    }
}

