/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.EnableLoggingRequest;

public class EnableLoggingRequestMarshaller
implements Marshaller<Request<EnableLoggingRequest>, EnableLoggingRequest> {
    public Request<EnableLoggingRequest> marshall(EnableLoggingRequest enableLoggingRequest) {
        if (enableLoggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableLoggingRequest, "RedshiftClient");
        request.addParameter("Action", "EnableLogging");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableLoggingRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)enableLoggingRequest.clusterIdentifier()));
        }
        if (enableLoggingRequest.bucketName() != null) {
            request.addParameter("BucketName", StringUtils.fromString((String)enableLoggingRequest.bucketName()));
        }
        if (enableLoggingRequest.s3KeyPrefix() != null) {
            request.addParameter("S3KeyPrefix", StringUtils.fromString((String)enableLoggingRequest.s3KeyPrefix()));
        }
        return request;
    }
}

