/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;

public class DescribeClusterSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeClusterSnapshotsRequest>, DescribeClusterSnapshotsRequest> {
    public Request<DescribeClusterSnapshotsRequest> marshall(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) {
        List<String> tagValuesList;
        List<String> tagKeysList;
        if (describeClusterSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClusterSnapshotsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterSnapshots");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterSnapshotsRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)describeClusterSnapshotsRequest.clusterIdentifier()));
        }
        if (describeClusterSnapshotsRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)describeClusterSnapshotsRequest.snapshotIdentifier()));
        }
        if (describeClusterSnapshotsRequest.snapshotType() != null) {
            request.addParameter("SnapshotType", StringUtils.fromString((String)describeClusterSnapshotsRequest.snapshotType()));
        }
        if (describeClusterSnapshotsRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant((Instant)describeClusterSnapshotsRequest.startTime()));
        }
        if (describeClusterSnapshotsRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromInstant((Instant)describeClusterSnapshotsRequest.endTime()));
        }
        if (describeClusterSnapshotsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeClusterSnapshotsRequest.maxRecords()));
        }
        if (describeClusterSnapshotsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeClusterSnapshotsRequest.marker()));
        }
        if (describeClusterSnapshotsRequest.ownerAccount() != null) {
            request.addParameter("OwnerAccount", StringUtils.fromString((String)describeClusterSnapshotsRequest.ownerAccount()));
        }
        if ((tagKeysList = describeClusterSnapshotsRequest.tagKeys()) != null) {
            if (!tagKeysList.isEmpty()) {
                int tagKeysListIndex = 1;
                for (String tagKeysListValue : tagKeysList) {
                    if (tagKeysListValue != null) {
                        request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                    }
                    ++tagKeysListIndex;
                }
            } else {
                request.addParameter("TagKeys", "");
            }
        }
        if ((tagValuesList = describeClusterSnapshotsRequest.tagValues()) != null) {
            if (!tagValuesList.isEmpty()) {
                int tagValuesListIndex = 1;
                for (String tagValuesListValue : tagValuesList) {
                    if (tagValuesListValue != null) {
                        request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                    }
                    ++tagValuesListIndex;
                }
            } else {
                request.addParameter("TagValues", "");
            }
        }
        return request;
    }
}

