/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest;

public class DescribeClusterSecurityGroupsRequestMarshaller
implements Marshaller<Request<DescribeClusterSecurityGroupsRequest>, DescribeClusterSecurityGroupsRequest> {
    public Request<DescribeClusterSecurityGroupsRequest> marshall(DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest) {
        List<String> tagValuesList;
        List<String> tagKeysList;
        if (describeClusterSecurityGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClusterSecurityGroupsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterSecurityGroups");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterSecurityGroupsRequest.clusterSecurityGroupName() != null) {
            request.addParameter("ClusterSecurityGroupName", StringUtils.fromString((String)describeClusterSecurityGroupsRequest.clusterSecurityGroupName()));
        }
        if (describeClusterSecurityGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeClusterSecurityGroupsRequest.maxRecords()));
        }
        if (describeClusterSecurityGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeClusterSecurityGroupsRequest.marker()));
        }
        if ((tagKeysList = describeClusterSecurityGroupsRequest.tagKeys()) != null) {
            if (!tagKeysList.isEmpty()) {
                int tagKeysListIndex = 1;
                for (String tagKeysListValue : tagKeysList) {
                    if (tagKeysListValue != null) {
                        request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                    }
                    ++tagKeysListIndex;
                }
            } else {
                request.addParameter("TagKeys", "");
            }
        }
        if ((tagValuesList = describeClusterSecurityGroupsRequest.tagValues()) != null) {
            if (!tagValuesList.isEmpty()) {
                int tagValuesListIndex = 1;
                for (String tagValuesListValue : tagValuesList) {
                    if (tagValuesListValue != null) {
                        request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                    }
                    ++tagValuesListIndex;
                }
            } else {
                request.addParameter("TagValues", "");
            }
        }
        return request;
    }
}

