/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.services.redshift.model.TableRestoreStatusType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TableRestoreStatus
implements ToCopyableBuilder<Builder, TableRestoreStatus> {
    private final String tableRestoreRequestId;
    private final String status;
    private final String message;
    private final Instant requestTime;
    private final Long progressInMegaBytes;
    private final Long totalDataInMegaBytes;
    private final String clusterIdentifier;
    private final String snapshotIdentifier;
    private final String sourceDatabaseName;
    private final String sourceSchemaName;
    private final String sourceTableName;
    private final String targetDatabaseName;
    private final String targetSchemaName;
    private final String newTableName;

    private TableRestoreStatus(BuilderImpl builder) {
        this.tableRestoreRequestId = builder.tableRestoreRequestId;
        this.status = builder.status;
        this.message = builder.message;
        this.requestTime = builder.requestTime;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.totalDataInMegaBytes = builder.totalDataInMegaBytes;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.sourceDatabaseName = builder.sourceDatabaseName;
        this.sourceSchemaName = builder.sourceSchemaName;
        this.sourceTableName = builder.sourceTableName;
        this.targetDatabaseName = builder.targetDatabaseName;
        this.targetSchemaName = builder.targetSchemaName;
        this.newTableName = builder.newTableName;
    }

    public String tableRestoreRequestId() {
        return this.tableRestoreRequestId;
    }

    public TableRestoreStatusType status() {
        return TableRestoreStatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Instant requestTime() {
        return this.requestTime;
    }

    public Long progressInMegaBytes() {
        return this.progressInMegaBytes;
    }

    public Long totalDataInMegaBytes() {
        return this.totalDataInMegaBytes;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String sourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    public String sourceSchemaName() {
        return this.sourceSchemaName;
    }

    public String sourceTableName() {
        return this.sourceTableName;
    }

    public String targetDatabaseName() {
        return this.targetDatabaseName;
    }

    public String targetSchemaName() {
        return this.targetSchemaName;
    }

    public String newTableName() {
        return this.newTableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tableRestoreRequestId() == null ? 0 : this.tableRestoreRequestId().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.requestTime() == null ? 0 : this.requestTime().hashCode());
        hashCode = 31 * hashCode + (this.progressInMegaBytes() == null ? 0 : this.progressInMegaBytes().hashCode());
        hashCode = 31 * hashCode + (this.totalDataInMegaBytes() == null ? 0 : this.totalDataInMegaBytes().hashCode());
        hashCode = 31 * hashCode + (this.clusterIdentifier() == null ? 0 : this.clusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.snapshotIdentifier() == null ? 0 : this.snapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.sourceDatabaseName() == null ? 0 : this.sourceDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.sourceSchemaName() == null ? 0 : this.sourceSchemaName().hashCode());
        hashCode = 31 * hashCode + (this.sourceTableName() == null ? 0 : this.sourceTableName().hashCode());
        hashCode = 31 * hashCode + (this.targetDatabaseName() == null ? 0 : this.targetDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.targetSchemaName() == null ? 0 : this.targetSchemaName().hashCode());
        hashCode = 31 * hashCode + (this.newTableName() == null ? 0 : this.newTableName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableRestoreStatus)) {
            return false;
        }
        TableRestoreStatus other = (TableRestoreStatus)obj;
        if (other.tableRestoreRequestId() == null ^ this.tableRestoreRequestId() == null) {
            return false;
        }
        if (other.tableRestoreRequestId() != null && !other.tableRestoreRequestId().equals(this.tableRestoreRequestId())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.requestTime() == null ^ this.requestTime() == null) {
            return false;
        }
        if (other.requestTime() != null && !other.requestTime().equals(this.requestTime())) {
            return false;
        }
        if (other.progressInMegaBytes() == null ^ this.progressInMegaBytes() == null) {
            return false;
        }
        if (other.progressInMegaBytes() != null && !other.progressInMegaBytes().equals(this.progressInMegaBytes())) {
            return false;
        }
        if (other.totalDataInMegaBytes() == null ^ this.totalDataInMegaBytes() == null) {
            return false;
        }
        if (other.totalDataInMegaBytes() != null && !other.totalDataInMegaBytes().equals(this.totalDataInMegaBytes())) {
            return false;
        }
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        if (other.snapshotIdentifier() == null ^ this.snapshotIdentifier() == null) {
            return false;
        }
        if (other.snapshotIdentifier() != null && !other.snapshotIdentifier().equals(this.snapshotIdentifier())) {
            return false;
        }
        if (other.sourceDatabaseName() == null ^ this.sourceDatabaseName() == null) {
            return false;
        }
        if (other.sourceDatabaseName() != null && !other.sourceDatabaseName().equals(this.sourceDatabaseName())) {
            return false;
        }
        if (other.sourceSchemaName() == null ^ this.sourceSchemaName() == null) {
            return false;
        }
        if (other.sourceSchemaName() != null && !other.sourceSchemaName().equals(this.sourceSchemaName())) {
            return false;
        }
        if (other.sourceTableName() == null ^ this.sourceTableName() == null) {
            return false;
        }
        if (other.sourceTableName() != null && !other.sourceTableName().equals(this.sourceTableName())) {
            return false;
        }
        if (other.targetDatabaseName() == null ^ this.targetDatabaseName() == null) {
            return false;
        }
        if (other.targetDatabaseName() != null && !other.targetDatabaseName().equals(this.targetDatabaseName())) {
            return false;
        }
        if (other.targetSchemaName() == null ^ this.targetSchemaName() == null) {
            return false;
        }
        if (other.targetSchemaName() != null && !other.targetSchemaName().equals(this.targetSchemaName())) {
            return false;
        }
        if (other.newTableName() == null ^ this.newTableName() == null) {
            return false;
        }
        return other.newTableName() == null || other.newTableName().equals(this.newTableName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tableRestoreRequestId() != null) {
            sb.append("TableRestoreRequestId: ").append(this.tableRestoreRequestId()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.requestTime() != null) {
            sb.append("RequestTime: ").append(this.requestTime()).append(",");
        }
        if (this.progressInMegaBytes() != null) {
            sb.append("ProgressInMegaBytes: ").append(this.progressInMegaBytes()).append(",");
        }
        if (this.totalDataInMegaBytes() != null) {
            sb.append("TotalDataInMegaBytes: ").append(this.totalDataInMegaBytes()).append(",");
        }
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.snapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: ").append(this.snapshotIdentifier()).append(",");
        }
        if (this.sourceDatabaseName() != null) {
            sb.append("SourceDatabaseName: ").append(this.sourceDatabaseName()).append(",");
        }
        if (this.sourceSchemaName() != null) {
            sb.append("SourceSchemaName: ").append(this.sourceSchemaName()).append(",");
        }
        if (this.sourceTableName() != null) {
            sb.append("SourceTableName: ").append(this.sourceTableName()).append(",");
        }
        if (this.targetDatabaseName() != null) {
            sb.append("TargetDatabaseName: ").append(this.targetDatabaseName()).append(",");
        }
        if (this.targetSchemaName() != null) {
            sb.append("TargetSchemaName: ").append(this.targetSchemaName()).append(",");
        }
        if (this.newTableName() != null) {
            sb.append("NewTableName: ").append(this.newTableName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableRestoreRequestId": {
                return Optional.of(clazz.cast(this.tableRestoreRequestId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "RequestTime": {
                return Optional.of(clazz.cast(this.requestTime()));
            }
            case "ProgressInMegaBytes": {
                return Optional.of(clazz.cast(this.progressInMegaBytes()));
            }
            case "TotalDataInMegaBytes": {
                return Optional.of(clazz.cast(this.totalDataInMegaBytes()));
            }
            case "ClusterIdentifier": {
                return Optional.of(clazz.cast(this.clusterIdentifier()));
            }
            case "SnapshotIdentifier": {
                return Optional.of(clazz.cast(this.snapshotIdentifier()));
            }
            case "SourceDatabaseName": {
                return Optional.of(clazz.cast(this.sourceDatabaseName()));
            }
            case "SourceSchemaName": {
                return Optional.of(clazz.cast(this.sourceSchemaName()));
            }
            case "SourceTableName": {
                return Optional.of(clazz.cast(this.sourceTableName()));
            }
            case "TargetDatabaseName": {
                return Optional.of(clazz.cast(this.targetDatabaseName()));
            }
            case "TargetSchemaName": {
                return Optional.of(clazz.cast(this.targetSchemaName()));
            }
            case "NewTableName": {
                return Optional.of(clazz.cast(this.newTableName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String tableRestoreRequestId;
        private String status;
        private String message;
        private Instant requestTime;
        private Long progressInMegaBytes;
        private Long totalDataInMegaBytes;
        private String clusterIdentifier;
        private String snapshotIdentifier;
        private String sourceDatabaseName;
        private String sourceSchemaName;
        private String sourceTableName;
        private String targetDatabaseName;
        private String targetSchemaName;
        private String newTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(TableRestoreStatus model) {
            this.tableRestoreRequestId(model.tableRestoreRequestId);
            this.status(model.status);
            this.message(model.message);
            this.requestTime(model.requestTime);
            this.progressInMegaBytes(model.progressInMegaBytes);
            this.totalDataInMegaBytes(model.totalDataInMegaBytes);
            this.clusterIdentifier(model.clusterIdentifier);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.sourceDatabaseName(model.sourceDatabaseName);
            this.sourceSchemaName(model.sourceSchemaName);
            this.sourceTableName(model.sourceTableName);
            this.targetDatabaseName(model.targetDatabaseName);
            this.targetSchemaName(model.targetSchemaName);
            this.newTableName(model.newTableName);
        }

        public final String getTableRestoreRequestId() {
            return this.tableRestoreRequestId;
        }

        @Override
        public final Builder tableRestoreRequestId(String tableRestoreRequestId) {
            this.tableRestoreRequestId = tableRestoreRequestId;
            return this;
        }

        public final void setTableRestoreRequestId(String tableRestoreRequestId) {
            this.tableRestoreRequestId = tableRestoreRequestId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TableRestoreStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getRequestTime() {
            return this.requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        public final Long getProgressInMegaBytes() {
            return this.progressInMegaBytes;
        }

        @Override
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        public final Long getTotalDataInMegaBytes() {
            return this.totalDataInMegaBytes;
        }

        @Override
        public final Builder totalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
            return this;
        }

        public final void setTotalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getSourceDatabaseName() {
            return this.sourceDatabaseName;
        }

        @Override
        public final Builder sourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
            return this;
        }

        public final void setSourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
        }

        public final String getSourceSchemaName() {
            return this.sourceSchemaName;
        }

        @Override
        public final Builder sourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
            return this;
        }

        public final void setSourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
        }

        public final String getSourceTableName() {
            return this.sourceTableName;
        }

        @Override
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        public final String getTargetDatabaseName() {
            return this.targetDatabaseName;
        }

        @Override
        public final Builder targetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
            return this;
        }

        public final void setTargetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
        }

        public final String getTargetSchemaName() {
            return this.targetSchemaName;
        }

        @Override
        public final Builder targetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
            return this;
        }

        public final void setTargetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
        }

        public final String getNewTableName() {
            return this.newTableName;
        }

        @Override
        public final Builder newTableName(String newTableName) {
            this.newTableName = newTableName;
            return this;
        }

        public final void setNewTableName(String newTableName) {
            this.newTableName = newTableName;
        }

        public TableRestoreStatus build() {
            return new TableRestoreStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TableRestoreStatus> {
        public Builder tableRestoreRequestId(String var1);

        public Builder status(String var1);

        public Builder status(TableRestoreStatusType var1);

        public Builder message(String var1);

        public Builder requestTime(Instant var1);

        public Builder progressInMegaBytes(Long var1);

        public Builder totalDataInMegaBytes(Long var1);

        public Builder clusterIdentifier(String var1);

        public Builder snapshotIdentifier(String var1);

        public Builder sourceDatabaseName(String var1);

        public Builder sourceSchemaName(String var1);

        public Builder sourceTableName(String var1);

        public Builder targetDatabaseName(String var1);

        public Builder targetSchemaName(String var1);

        public Builder newTableName(String var1);
    }
}

