/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupNameListCopier;
import software.amazon.awssdk.services.redshift.model.IamRoleArnListCopier;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RestoreFromClusterSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RestoreFromClusterSnapshotRequest> {
    private final String clusterIdentifier;
    private final String snapshotIdentifier;
    private final String snapshotClusterIdentifier;
    private final Integer port;
    private final String availabilityZone;
    private final Boolean allowVersionUpgrade;
    private final String clusterSubnetGroupName;
    private final Boolean publiclyAccessible;
    private final String ownerAccount;
    private final String hsmClientCertificateIdentifier;
    private final String hsmConfigurationIdentifier;
    private final String elasticIp;
    private final String clusterParameterGroupName;
    private final List<String> clusterSecurityGroups;
    private final List<String> vpcSecurityGroupIds;
    private final String preferredMaintenanceWindow;
    private final Integer automatedSnapshotRetentionPeriod;
    private final String kmsKeyId;
    private final String nodeType;
    private final Boolean enhancedVpcRouting;
    private final String additionalInfo;
    private final List<String> iamRoles;

    private RestoreFromClusterSnapshotRequest(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.ownerAccount = builder.ownerAccount;
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.elasticIp = builder.elasticIp;
        this.clusterParameterGroupName = builder.clusterParameterGroupName;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.kmsKeyId = builder.kmsKeyId;
        this.nodeType = builder.nodeType;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.additionalInfo = builder.additionalInfo;
        this.iamRoles = builder.iamRoles;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String snapshotClusterIdentifier() {
        return this.snapshotClusterIdentifier;
    }

    public Integer port() {
        return this.port;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Boolean allowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public String clusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public String hsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public String hsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public String elasticIp() {
        return this.elasticIp;
    }

    public String clusterParameterGroupName() {
        return this.clusterParameterGroupName;
    }

    public List<String> clusterSecurityGroups() {
        return this.clusterSecurityGroups;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Integer automatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public String additionalInfo() {
        return this.additionalInfo;
    }

    public List<String> iamRoles() {
        return this.iamRoles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterIdentifier() == null ? 0 : this.clusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.snapshotIdentifier() == null ? 0 : this.snapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.snapshotClusterIdentifier() == null ? 0 : this.snapshotClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.allowVersionUpgrade() == null ? 0 : this.allowVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.clusterSubnetGroupName() == null ? 0 : this.clusterSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.publiclyAccessible() == null ? 0 : this.publiclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.ownerAccount() == null ? 0 : this.ownerAccount().hashCode());
        hashCode = 31 * hashCode + (this.hsmClientCertificateIdentifier() == null ? 0 : this.hsmClientCertificateIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.hsmConfigurationIdentifier() == null ? 0 : this.hsmConfigurationIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.elasticIp() == null ? 0 : this.elasticIp().hashCode());
        hashCode = 31 * hashCode + (this.clusterParameterGroupName() == null ? 0 : this.clusterParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.clusterSecurityGroups() == null ? 0 : this.clusterSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.vpcSecurityGroupIds() == null ? 0 : this.vpcSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.automatedSnapshotRetentionPeriod() == null ? 0 : this.automatedSnapshotRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.nodeType() == null ? 0 : this.nodeType().hashCode());
        hashCode = 31 * hashCode + (this.enhancedVpcRouting() == null ? 0 : this.enhancedVpcRouting().hashCode());
        hashCode = 31 * hashCode + (this.additionalInfo() == null ? 0 : this.additionalInfo().hashCode());
        hashCode = 31 * hashCode + (this.iamRoles() == null ? 0 : this.iamRoles().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreFromClusterSnapshotRequest)) {
            return false;
        }
        RestoreFromClusterSnapshotRequest other = (RestoreFromClusterSnapshotRequest)((Object)obj);
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        if (other.snapshotIdentifier() == null ^ this.snapshotIdentifier() == null) {
            return false;
        }
        if (other.snapshotIdentifier() != null && !other.snapshotIdentifier().equals(this.snapshotIdentifier())) {
            return false;
        }
        if (other.snapshotClusterIdentifier() == null ^ this.snapshotClusterIdentifier() == null) {
            return false;
        }
        if (other.snapshotClusterIdentifier() != null && !other.snapshotClusterIdentifier().equals(this.snapshotClusterIdentifier())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.allowVersionUpgrade() == null ^ this.allowVersionUpgrade() == null) {
            return false;
        }
        if (other.allowVersionUpgrade() != null && !other.allowVersionUpgrade().equals(this.allowVersionUpgrade())) {
            return false;
        }
        if (other.clusterSubnetGroupName() == null ^ this.clusterSubnetGroupName() == null) {
            return false;
        }
        if (other.clusterSubnetGroupName() != null && !other.clusterSubnetGroupName().equals(this.clusterSubnetGroupName())) {
            return false;
        }
        if (other.publiclyAccessible() == null ^ this.publiclyAccessible() == null) {
            return false;
        }
        if (other.publiclyAccessible() != null && !other.publiclyAccessible().equals(this.publiclyAccessible())) {
            return false;
        }
        if (other.ownerAccount() == null ^ this.ownerAccount() == null) {
            return false;
        }
        if (other.ownerAccount() != null && !other.ownerAccount().equals(this.ownerAccount())) {
            return false;
        }
        if (other.hsmClientCertificateIdentifier() == null ^ this.hsmClientCertificateIdentifier() == null) {
            return false;
        }
        if (other.hsmClientCertificateIdentifier() != null && !other.hsmClientCertificateIdentifier().equals(this.hsmClientCertificateIdentifier())) {
            return false;
        }
        if (other.hsmConfigurationIdentifier() == null ^ this.hsmConfigurationIdentifier() == null) {
            return false;
        }
        if (other.hsmConfigurationIdentifier() != null && !other.hsmConfigurationIdentifier().equals(this.hsmConfigurationIdentifier())) {
            return false;
        }
        if (other.elasticIp() == null ^ this.elasticIp() == null) {
            return false;
        }
        if (other.elasticIp() != null && !other.elasticIp().equals(this.elasticIp())) {
            return false;
        }
        if (other.clusterParameterGroupName() == null ^ this.clusterParameterGroupName() == null) {
            return false;
        }
        if (other.clusterParameterGroupName() != null && !other.clusterParameterGroupName().equals(this.clusterParameterGroupName())) {
            return false;
        }
        if (other.clusterSecurityGroups() == null ^ this.clusterSecurityGroups() == null) {
            return false;
        }
        if (other.clusterSecurityGroups() != null && !other.clusterSecurityGroups().equals(this.clusterSecurityGroups())) {
            return false;
        }
        if (other.vpcSecurityGroupIds() == null ^ this.vpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.vpcSecurityGroupIds() != null && !other.vpcSecurityGroupIds().equals(this.vpcSecurityGroupIds())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.automatedSnapshotRetentionPeriod() == null ^ this.automatedSnapshotRetentionPeriod() == null) {
            return false;
        }
        if (other.automatedSnapshotRetentionPeriod() != null && !other.automatedSnapshotRetentionPeriod().equals(this.automatedSnapshotRetentionPeriod())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.nodeType() == null ^ this.nodeType() == null) {
            return false;
        }
        if (other.nodeType() != null && !other.nodeType().equals(this.nodeType())) {
            return false;
        }
        if (other.enhancedVpcRouting() == null ^ this.enhancedVpcRouting() == null) {
            return false;
        }
        if (other.enhancedVpcRouting() != null && !other.enhancedVpcRouting().equals(this.enhancedVpcRouting())) {
            return false;
        }
        if (other.additionalInfo() == null ^ this.additionalInfo() == null) {
            return false;
        }
        if (other.additionalInfo() != null && !other.additionalInfo().equals(this.additionalInfo())) {
            return false;
        }
        if (other.iamRoles() == null ^ this.iamRoles() == null) {
            return false;
        }
        return other.iamRoles() == null || other.iamRoles().equals(this.iamRoles());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.snapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: ").append(this.snapshotIdentifier()).append(",");
        }
        if (this.snapshotClusterIdentifier() != null) {
            sb.append("SnapshotClusterIdentifier: ").append(this.snapshotClusterIdentifier()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.allowVersionUpgrade() != null) {
            sb.append("AllowVersionUpgrade: ").append(this.allowVersionUpgrade()).append(",");
        }
        if (this.clusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: ").append(this.clusterSubnetGroupName()).append(",");
        }
        if (this.publiclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.publiclyAccessible()).append(",");
        }
        if (this.ownerAccount() != null) {
            sb.append("OwnerAccount: ").append(this.ownerAccount()).append(",");
        }
        if (this.hsmClientCertificateIdentifier() != null) {
            sb.append("HsmClientCertificateIdentifier: ").append(this.hsmClientCertificateIdentifier()).append(",");
        }
        if (this.hsmConfigurationIdentifier() != null) {
            sb.append("HsmConfigurationIdentifier: ").append(this.hsmConfigurationIdentifier()).append(",");
        }
        if (this.elasticIp() != null) {
            sb.append("ElasticIp: ").append(this.elasticIp()).append(",");
        }
        if (this.clusterParameterGroupName() != null) {
            sb.append("ClusterParameterGroupName: ").append(this.clusterParameterGroupName()).append(",");
        }
        if (this.clusterSecurityGroups() != null) {
            sb.append("ClusterSecurityGroups: ").append(this.clusterSecurityGroups()).append(",");
        }
        if (this.vpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: ").append(this.vpcSecurityGroupIds()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.automatedSnapshotRetentionPeriod() != null) {
            sb.append("AutomatedSnapshotRetentionPeriod: ").append(this.automatedSnapshotRetentionPeriod()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.nodeType() != null) {
            sb.append("NodeType: ").append(this.nodeType()).append(",");
        }
        if (this.enhancedVpcRouting() != null) {
            sb.append("EnhancedVpcRouting: ").append(this.enhancedVpcRouting()).append(",");
        }
        if (this.additionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.additionalInfo()).append(",");
        }
        if (this.iamRoles() != null) {
            sb.append("IamRoles: ").append(this.iamRoles()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.of(clazz.cast(this.clusterIdentifier()));
            }
            case "SnapshotIdentifier": {
                return Optional.of(clazz.cast(this.snapshotIdentifier()));
            }
            case "SnapshotClusterIdentifier": {
                return Optional.of(clazz.cast(this.snapshotClusterIdentifier()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "AllowVersionUpgrade": {
                return Optional.of(clazz.cast(this.allowVersionUpgrade()));
            }
            case "ClusterSubnetGroupName": {
                return Optional.of(clazz.cast(this.clusterSubnetGroupName()));
            }
            case "PubliclyAccessible": {
                return Optional.of(clazz.cast(this.publiclyAccessible()));
            }
            case "OwnerAccount": {
                return Optional.of(clazz.cast(this.ownerAccount()));
            }
            case "HsmClientCertificateIdentifier": {
                return Optional.of(clazz.cast(this.hsmClientCertificateIdentifier()));
            }
            case "HsmConfigurationIdentifier": {
                return Optional.of(clazz.cast(this.hsmConfigurationIdentifier()));
            }
            case "ElasticIp": {
                return Optional.of(clazz.cast(this.elasticIp()));
            }
            case "ClusterParameterGroupName": {
                return Optional.of(clazz.cast(this.clusterParameterGroupName()));
            }
            case "ClusterSecurityGroups": {
                return Optional.of(clazz.cast(this.clusterSecurityGroups()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.of(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.of(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "AutomatedSnapshotRetentionPeriod": {
                return Optional.of(clazz.cast(this.automatedSnapshotRetentionPeriod()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "NodeType": {
                return Optional.of(clazz.cast(this.nodeType()));
            }
            case "EnhancedVpcRouting": {
                return Optional.of(clazz.cast(this.enhancedVpcRouting()));
            }
            case "AdditionalInfo": {
                return Optional.of(clazz.cast(this.additionalInfo()));
            }
            case "IamRoles": {
                return Optional.of(clazz.cast(this.iamRoles()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String snapshotIdentifier;
        private String snapshotClusterIdentifier;
        private Integer port;
        private String availabilityZone;
        private Boolean allowVersionUpgrade;
        private String clusterSubnetGroupName;
        private Boolean publiclyAccessible;
        private String ownerAccount;
        private String hsmClientCertificateIdentifier;
        private String hsmConfigurationIdentifier;
        private String elasticIp;
        private String clusterParameterGroupName;
        private List<String> clusterSecurityGroups;
        private List<String> vpcSecurityGroupIds;
        private String preferredMaintenanceWindow;
        private Integer automatedSnapshotRetentionPeriod;
        private String kmsKeyId;
        private String nodeType;
        private Boolean enhancedVpcRouting;
        private String additionalInfo;
        private List<String> iamRoles;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreFromClusterSnapshotRequest model) {
            this.clusterIdentifier(model.clusterIdentifier);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.snapshotClusterIdentifier(model.snapshotClusterIdentifier);
            this.port(model.port);
            this.availabilityZone(model.availabilityZone);
            this.allowVersionUpgrade(model.allowVersionUpgrade);
            this.clusterSubnetGroupName(model.clusterSubnetGroupName);
            this.publiclyAccessible(model.publiclyAccessible);
            this.ownerAccount(model.ownerAccount);
            this.hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            this.hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            this.elasticIp(model.elasticIp);
            this.clusterParameterGroupName(model.clusterParameterGroupName);
            this.clusterSecurityGroups(model.clusterSecurityGroups);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            this.kmsKeyId(model.kmsKeyId);
            this.nodeType(model.nodeType);
            this.enhancedVpcRouting(model.enhancedVpcRouting);
            this.additionalInfo(model.additionalInfo);
            this.iamRoles(model.iamRoles);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getSnapshotClusterIdentifier() {
            return this.snapshotClusterIdentifier;
        }

        @Override
        public final Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        public final void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Boolean getAllowVersionUpgrade() {
            return this.allowVersionUpgrade;
        }

        @Override
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        public final String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        public final String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        public final String getElasticIp() {
            return this.elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        public final String getClusterParameterGroupName() {
            return this.clusterParameterGroupName;
        }

        @Override
        public final Builder clusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
            return this;
        }

        public final void setClusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
        }

        public final Collection<String> getClusterSecurityGroups() {
            return this.clusterSecurityGroups;
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(String ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        public final void setClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return this.automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public final Collection<String> getIamRoles() {
            return this.iamRoles;
        }

        @Override
        public final Builder iamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(String ... iamRoles) {
            this.iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        public final void setIamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
        }

        public RestoreFromClusterSnapshotRequest build() {
            return new RestoreFromClusterSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RestoreFromClusterSnapshotRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder snapshotIdentifier(String var1);

        public Builder snapshotClusterIdentifier(String var1);

        public Builder port(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder allowVersionUpgrade(Boolean var1);

        public Builder clusterSubnetGroupName(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder ownerAccount(String var1);

        public Builder hsmClientCertificateIdentifier(String var1);

        public Builder hsmConfigurationIdentifier(String var1);

        public Builder elasticIp(String var1);

        public Builder clusterParameterGroupName(String var1);

        public Builder clusterSecurityGroups(Collection<String> var1);

        public Builder clusterSecurityGroups(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder automatedSnapshotRetentionPeriod(Integer var1);

        public Builder kmsKeyId(String var1);

        public Builder nodeType(String var1);

        public Builder enhancedVpcRouting(Boolean var1);

        public Builder additionalInfo(String var1);

        public Builder iamRoles(Collection<String> var1);

        public Builder iamRoles(String ... var1);
    }
}

