/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.redshift.model.AvailabilityZone;
import software.amazon.awssdk.services.redshift.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OrderableClusterOption
implements ToCopyableBuilder<Builder, OrderableClusterOption> {
    private final String clusterVersion;
    private final String clusterType;
    private final String nodeType;
    private final List<AvailabilityZone> availabilityZones;

    private OrderableClusterOption(BuilderImpl builder) {
        this.clusterVersion = builder.clusterVersion;
        this.clusterType = builder.clusterType;
        this.nodeType = builder.nodeType;
        this.availabilityZones = builder.availabilityZones;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public String clusterType() {
        return this.clusterType;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public List<AvailabilityZone> availabilityZones() {
        return this.availabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterVersion() == null ? 0 : this.clusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.clusterType() == null ? 0 : this.clusterType().hashCode());
        hashCode = 31 * hashCode + (this.nodeType() == null ? 0 : this.nodeType().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderableClusterOption)) {
            return false;
        }
        OrderableClusterOption other = (OrderableClusterOption)obj;
        if (other.clusterVersion() == null ^ this.clusterVersion() == null) {
            return false;
        }
        if (other.clusterVersion() != null && !other.clusterVersion().equals(this.clusterVersion())) {
            return false;
        }
        if (other.clusterType() == null ^ this.clusterType() == null) {
            return false;
        }
        if (other.clusterType() != null && !other.clusterType().equals(this.clusterType())) {
            return false;
        }
        if (other.nodeType() == null ^ this.nodeType() == null) {
            return false;
        }
        if (other.nodeType() != null && !other.nodeType().equals(this.nodeType())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        return other.availabilityZones() == null || other.availabilityZones().equals(this.availabilityZones());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterVersion() != null) {
            sb.append("ClusterVersion: ").append(this.clusterVersion()).append(",");
        }
        if (this.clusterType() != null) {
            sb.append("ClusterType: ").append(this.clusterType()).append(",");
        }
        if (this.nodeType() != null) {
            sb.append("NodeType: ").append(this.nodeType()).append(",");
        }
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterVersion": {
                return Optional.of(clazz.cast(this.clusterVersion()));
            }
            case "ClusterType": {
                return Optional.of(clazz.cast(this.clusterType()));
            }
            case "NodeType": {
                return Optional.of(clazz.cast(this.nodeType()));
            }
            case "AvailabilityZones": {
                return Optional.of(clazz.cast(this.availabilityZones()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterVersion;
        private String clusterType;
        private String nodeType;
        private List<AvailabilityZone> availabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderableClusterOption model) {
            this.clusterVersion(model.clusterVersion);
            this.clusterType(model.clusterType);
            this.nodeType(model.nodeType);
            this.availabilityZones(model.availabilityZones);
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Collection<AvailabilityZone.Builder> getAvailabilityZones() {
            return this.availabilityZones != null ? (Collection)this.availabilityZones.stream().map(AvailabilityZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copyFromBuilder(availabilityZones);
        }

        public OrderableClusterOption build() {
            return new OrderableClusterOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OrderableClusterOption> {
        public Builder clusterVersion(String var1);

        public Builder clusterType(String var1);

        public Builder nodeType(String var1);

        public Builder availabilityZones(Collection<AvailabilityZone> var1);

        public Builder availabilityZones(AvailabilityZone ... var1);
    }
}

