/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisableLoggingResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DisableLoggingResponse> {
    private final Boolean loggingEnabled;
    private final String bucketName;
    private final String s3KeyPrefix;
    private final Instant lastSuccessfulDeliveryTime;
    private final Instant lastFailureTime;
    private final String lastFailureMessage;

    private DisableLoggingResponse(BuilderImpl builder) {
        this.loggingEnabled = builder.loggingEnabled;
        this.bucketName = builder.bucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.lastSuccessfulDeliveryTime = builder.lastSuccessfulDeliveryTime;
        this.lastFailureTime = builder.lastFailureTime;
        this.lastFailureMessage = builder.lastFailureMessage;
    }

    public Boolean loggingEnabled() {
        return this.loggingEnabled;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public Instant lastSuccessfulDeliveryTime() {
        return this.lastSuccessfulDeliveryTime;
    }

    public Instant lastFailureTime() {
        return this.lastFailureTime;
    }

    public String lastFailureMessage() {
        return this.lastFailureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loggingEnabled() == null ? 0 : this.loggingEnabled().hashCode());
        hashCode = 31 * hashCode + (this.bucketName() == null ? 0 : this.bucketName().hashCode());
        hashCode = 31 * hashCode + (this.s3KeyPrefix() == null ? 0 : this.s3KeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.lastSuccessfulDeliveryTime() == null ? 0 : this.lastSuccessfulDeliveryTime().hashCode());
        hashCode = 31 * hashCode + (this.lastFailureTime() == null ? 0 : this.lastFailureTime().hashCode());
        hashCode = 31 * hashCode + (this.lastFailureMessage() == null ? 0 : this.lastFailureMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableLoggingResponse)) {
            return false;
        }
        DisableLoggingResponse other = (DisableLoggingResponse)((Object)obj);
        if (other.loggingEnabled() == null ^ this.loggingEnabled() == null) {
            return false;
        }
        if (other.loggingEnabled() != null && !other.loggingEnabled().equals(this.loggingEnabled())) {
            return false;
        }
        if (other.bucketName() == null ^ this.bucketName() == null) {
            return false;
        }
        if (other.bucketName() != null && !other.bucketName().equals(this.bucketName())) {
            return false;
        }
        if (other.s3KeyPrefix() == null ^ this.s3KeyPrefix() == null) {
            return false;
        }
        if (other.s3KeyPrefix() != null && !other.s3KeyPrefix().equals(this.s3KeyPrefix())) {
            return false;
        }
        if (other.lastSuccessfulDeliveryTime() == null ^ this.lastSuccessfulDeliveryTime() == null) {
            return false;
        }
        if (other.lastSuccessfulDeliveryTime() != null && !other.lastSuccessfulDeliveryTime().equals(this.lastSuccessfulDeliveryTime())) {
            return false;
        }
        if (other.lastFailureTime() == null ^ this.lastFailureTime() == null) {
            return false;
        }
        if (other.lastFailureTime() != null && !other.lastFailureTime().equals(this.lastFailureTime())) {
            return false;
        }
        if (other.lastFailureMessage() == null ^ this.lastFailureMessage() == null) {
            return false;
        }
        return other.lastFailureMessage() == null || other.lastFailureMessage().equals(this.lastFailureMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.loggingEnabled() != null) {
            sb.append("LoggingEnabled: ").append(this.loggingEnabled()).append(",");
        }
        if (this.bucketName() != null) {
            sb.append("BucketName: ").append(this.bucketName()).append(",");
        }
        if (this.s3KeyPrefix() != null) {
            sb.append("S3KeyPrefix: ").append(this.s3KeyPrefix()).append(",");
        }
        if (this.lastSuccessfulDeliveryTime() != null) {
            sb.append("LastSuccessfulDeliveryTime: ").append(this.lastSuccessfulDeliveryTime()).append(",");
        }
        if (this.lastFailureTime() != null) {
            sb.append("LastFailureTime: ").append(this.lastFailureTime()).append(",");
        }
        if (this.lastFailureMessage() != null) {
            sb.append("LastFailureMessage: ").append(this.lastFailureMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoggingEnabled": {
                return Optional.of(clazz.cast(this.loggingEnabled()));
            }
            case "BucketName": {
                return Optional.of(clazz.cast(this.bucketName()));
            }
            case "S3KeyPrefix": {
                return Optional.of(clazz.cast(this.s3KeyPrefix()));
            }
            case "LastSuccessfulDeliveryTime": {
                return Optional.of(clazz.cast(this.lastSuccessfulDeliveryTime()));
            }
            case "LastFailureTime": {
                return Optional.of(clazz.cast(this.lastFailureTime()));
            }
            case "LastFailureMessage": {
                return Optional.of(clazz.cast(this.lastFailureMessage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean loggingEnabled;
        private String bucketName;
        private String s3KeyPrefix;
        private Instant lastSuccessfulDeliveryTime;
        private Instant lastFailureTime;
        private String lastFailureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableLoggingResponse model) {
            this.loggingEnabled(model.loggingEnabled);
            this.bucketName(model.bucketName);
            this.s3KeyPrefix(model.s3KeyPrefix);
            this.lastSuccessfulDeliveryTime(model.lastSuccessfulDeliveryTime);
            this.lastFailureTime(model.lastFailureTime);
            this.lastFailureMessage(model.lastFailureMessage);
        }

        public final Boolean getLoggingEnabled() {
            return this.loggingEnabled;
        }

        @Override
        public final Builder loggingEnabled(Boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
            return this;
        }

        public final void setLoggingEnabled(Boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final Instant getLastSuccessfulDeliveryTime() {
            return this.lastSuccessfulDeliveryTime;
        }

        @Override
        public final Builder lastSuccessfulDeliveryTime(Instant lastSuccessfulDeliveryTime) {
            this.lastSuccessfulDeliveryTime = lastSuccessfulDeliveryTime;
            return this;
        }

        public final void setLastSuccessfulDeliveryTime(Instant lastSuccessfulDeliveryTime) {
            this.lastSuccessfulDeliveryTime = lastSuccessfulDeliveryTime;
        }

        public final Instant getLastFailureTime() {
            return this.lastFailureTime;
        }

        @Override
        public final Builder lastFailureTime(Instant lastFailureTime) {
            this.lastFailureTime = lastFailureTime;
            return this;
        }

        public final void setLastFailureTime(Instant lastFailureTime) {
            this.lastFailureTime = lastFailureTime;
        }

        public final String getLastFailureMessage() {
            return this.lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        public DisableLoggingResponse build() {
            return new DisableLoggingResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DisableLoggingResponse> {
        public Builder loggingEnabled(Boolean var1);

        public Builder bucketName(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder lastSuccessfulDeliveryTime(Instant var1);

        public Builder lastFailureTime(Instant var1);

        public Builder lastFailureMessage(String var1);
    }
}

