/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest;
import software.amazon.awssdk.util.StringUtils;

public class RestoreFromClusterSnapshotRequestMarshaller
implements Marshaller<Request<RestoreFromClusterSnapshotRequest>, RestoreFromClusterSnapshotRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<RestoreFromClusterSnapshotRequest> marshall(RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest) {
        List<String> iamRolesList;
        List<String> vpcSecurityGroupIdsList;
        List<String> clusterSecurityGroupsList;
        if (restoreFromClusterSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreFromClusterSnapshotRequest, "RedshiftClient");
        request.addParameter("Action", "RestoreFromClusterSnapshot");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreFromClusterSnapshotRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.clusterIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.snapshotIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.snapshotClusterIdentifier() != null) {
            request.addParameter("SnapshotClusterIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.snapshotClusterIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreFromClusterSnapshotRequest.port()));
        }
        if (restoreFromClusterSnapshotRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.availabilityZone()));
        }
        if (restoreFromClusterSnapshotRequest.allowVersionUpgrade() != null) {
            request.addParameter("AllowVersionUpgrade", StringUtils.fromBoolean((Boolean)restoreFromClusterSnapshotRequest.allowVersionUpgrade()));
        }
        if (restoreFromClusterSnapshotRequest.clusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.clusterSubnetGroupName()));
        }
        if (restoreFromClusterSnapshotRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)restoreFromClusterSnapshotRequest.publiclyAccessible()));
        }
        if (restoreFromClusterSnapshotRequest.ownerAccount() != null) {
            request.addParameter("OwnerAccount", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.ownerAccount()));
        }
        if (restoreFromClusterSnapshotRequest.hsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.hsmClientCertificateIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.hsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.hsmConfigurationIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.elasticIp() != null) {
            request.addParameter("ElasticIp", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.elasticIp()));
        }
        if (restoreFromClusterSnapshotRequest.clusterParameterGroupName() != null) {
            request.addParameter("ClusterParameterGroupName", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.clusterParameterGroupName()));
        }
        if ((clusterSecurityGroupsList = restoreFromClusterSnapshotRequest.clusterSecurityGroups()) != null) {
            if (!clusterSecurityGroupsList.isEmpty()) {
                int clusterSecurityGroupsListIndex = 1;
                for (String string : clusterSecurityGroupsList) {
                    if (string != null) {
                        request.addParameter("ClusterSecurityGroups.ClusterSecurityGroupName." + clusterSecurityGroupsListIndex, StringUtils.fromString((String)string));
                    }
                    ++clusterSecurityGroupsListIndex;
                }
            } else {
                request.addParameter("ClusterSecurityGroups", "");
            }
        }
        if ((vpcSecurityGroupIdsList = restoreFromClusterSnapshotRequest.vpcSecurityGroupIds()) != null) {
            if (!vpcSecurityGroupIdsList.isEmpty()) {
                int vpcSecurityGroupIdsListIndex = 1;
                for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                    if (vpcSecurityGroupIdsListValue != null) {
                        request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                    }
                    ++vpcSecurityGroupIdsListIndex;
                }
            } else {
                request.addParameter("VpcSecurityGroupIds", "");
            }
        }
        if (restoreFromClusterSnapshotRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.preferredMaintenanceWindow()));
        }
        if (restoreFromClusterSnapshotRequest.automatedSnapshotRetentionPeriod() != null) {
            request.addParameter("AutomatedSnapshotRetentionPeriod", StringUtils.fromInteger((Integer)restoreFromClusterSnapshotRequest.automatedSnapshotRetentionPeriod()));
        }
        if (restoreFromClusterSnapshotRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.kmsKeyId()));
        }
        if (restoreFromClusterSnapshotRequest.nodeType() != null) {
            request.addParameter("NodeType", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.nodeType()));
        }
        if (restoreFromClusterSnapshotRequest.enhancedVpcRouting() != null) {
            request.addParameter("EnhancedVpcRouting", StringUtils.fromBoolean((Boolean)restoreFromClusterSnapshotRequest.enhancedVpcRouting()));
        }
        if (restoreFromClusterSnapshotRequest.additionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.additionalInfo()));
        }
        if ((iamRolesList = restoreFromClusterSnapshotRequest.iamRoles()) != null) {
            if (!iamRolesList.isEmpty()) {
                boolean bl = true;
                for (String iamRolesListValue : iamRolesList) {
                    void var6_12;
                    if (iamRolesListValue != null) {
                        request.addParameter("IamRoles.IamRoleArn." + (int)var6_12, StringUtils.fromString((String)iamRolesListValue));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("IamRoles", "");
            }
        }
        return request;
    }
}

