/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyClusterSubnetGroupRequestMarshaller
implements Marshaller<Request<ModifyClusterSubnetGroupRequest>, ModifyClusterSubnetGroupRequest> {
    public Request<ModifyClusterSubnetGroupRequest> marshall(ModifyClusterSubnetGroupRequest modifyClusterSubnetGroupRequest) {
        List<String> subnetIdsList;
        if (modifyClusterSubnetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyClusterSubnetGroupRequest, "RedshiftClient");
        request.addParameter("Action", "ModifyClusterSubnetGroup");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyClusterSubnetGroupRequest.clusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringUtils.fromString((String)modifyClusterSubnetGroupRequest.clusterSubnetGroupName()));
        }
        if (modifyClusterSubnetGroupRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)modifyClusterSubnetGroupRequest.description()));
        }
        if ((subnetIdsList = modifyClusterSubnetGroupRequest.subnetIds()) != null) {
            if (!subnetIdsList.isEmpty()) {
                int subnetIdsListIndex = 1;
                for (String subnetIdsListValue : subnetIdsList) {
                    if (subnetIdsListValue != null) {
                        request.addParameter("SubnetIds.SubnetIdentifier." + subnetIdsListIndex, StringUtils.fromString((String)subnetIdsListValue));
                    }
                    ++subnetIdsListIndex;
                }
            } else {
                request.addParameter("SubnetIds", "");
            }
        }
        return request;
    }
}

