/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrant;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSnapshotCopyGrantsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSnapshotCopyGrantsResponse> {
    private final String marker;
    private final List<SnapshotCopyGrant> snapshotCopyGrants;

    private DescribeSnapshotCopyGrantsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.snapshotCopyGrants = builder.snapshotCopyGrants;
    }

    public String marker() {
        return this.marker;
    }

    public List<SnapshotCopyGrant> snapshotCopyGrants() {
        return this.snapshotCopyGrants;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.snapshotCopyGrants() == null ? 0 : this.snapshotCopyGrants().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotCopyGrantsResponse)) {
            return false;
        }
        DescribeSnapshotCopyGrantsResponse other = (DescribeSnapshotCopyGrantsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.snapshotCopyGrants() == null ^ this.snapshotCopyGrants() == null) {
            return false;
        }
        return other.snapshotCopyGrants() == null || other.snapshotCopyGrants().equals(this.snapshotCopyGrants());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.snapshotCopyGrants() != null) {
            sb.append("SnapshotCopyGrants: ").append(this.snapshotCopyGrants()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<SnapshotCopyGrant> snapshotCopyGrants;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotCopyGrantsResponse model) {
            this.setMarker(model.marker);
            this.setSnapshotCopyGrants(model.snapshotCopyGrants);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<SnapshotCopyGrant> getSnapshotCopyGrants() {
            return this.snapshotCopyGrants;
        }

        @Override
        public final Builder snapshotCopyGrants(Collection<SnapshotCopyGrant> snapshotCopyGrants) {
            this.snapshotCopyGrants = SnapshotCopyGrantListCopier.copy(snapshotCopyGrants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotCopyGrants(SnapshotCopyGrant ... snapshotCopyGrants) {
            this.snapshotCopyGrants(Arrays.asList(snapshotCopyGrants));
            return this;
        }

        public final void setSnapshotCopyGrants(Collection<SnapshotCopyGrant> snapshotCopyGrants) {
            this.snapshotCopyGrants = SnapshotCopyGrantListCopier.copy(snapshotCopyGrants);
        }

        public DescribeSnapshotCopyGrantsResponse build() {
            return new DescribeSnapshotCopyGrantsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSnapshotCopyGrantsResponse> {
        public Builder marker(String var1);

        public Builder snapshotCopyGrants(Collection<SnapshotCopyGrant> var1);

        public Builder snapshotCopyGrants(SnapshotCopyGrant ... var1);
    }
}

