/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroup;
import software.amazon.awssdk.services.redshift.model.ParameterGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClusterParameterGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeClusterParameterGroupsResponse> {
    private final String marker;
    private final List<ClusterParameterGroup> parameterGroups;

    private DescribeClusterParameterGroupsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.parameterGroups = builder.parameterGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<ClusterParameterGroup> parameterGroups() {
        return this.parameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.parameterGroups() == null ? 0 : this.parameterGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterParameterGroupsResponse)) {
            return false;
        }
        DescribeClusterParameterGroupsResponse other = (DescribeClusterParameterGroupsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.parameterGroups() == null ^ this.parameterGroups() == null) {
            return false;
        }
        return other.parameterGroups() == null || other.parameterGroups().equals(this.parameterGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.parameterGroups() != null) {
            sb.append("ParameterGroups: ").append(this.parameterGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<ClusterParameterGroup> parameterGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterParameterGroupsResponse model) {
            this.setMarker(model.marker);
            this.setParameterGroups(model.parameterGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterParameterGroup> getParameterGroups() {
            return this.parameterGroups;
        }

        @Override
        public final Builder parameterGroups(Collection<ClusterParameterGroup> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copy(parameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(ClusterParameterGroup ... parameterGroups) {
            this.parameterGroups(Arrays.asList(parameterGroups));
            return this;
        }

        public final void setParameterGroups(Collection<ClusterParameterGroup> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copy(parameterGroups);
        }

        public DescribeClusterParameterGroupsResponse build() {
            return new DescribeClusterParameterGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeClusterParameterGroupsResponse> {
        public Builder marker(String var1);

        public Builder parameterGroups(Collection<ClusterParameterGroup> var1);

        public Builder parameterGroups(ClusterParameterGroup ... var1);
    }
}

