/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClusterVersion
implements ToCopyableBuilder<Builder, ClusterVersion> {
    private final String clusterVersion;
    private final String clusterParameterGroupFamily;
    private final String description;

    private ClusterVersion(BuilderImpl builder) {
        this.clusterVersion = builder.clusterVersion;
        this.clusterParameterGroupFamily = builder.clusterParameterGroupFamily;
        this.description = builder.description;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public String clusterParameterGroupFamily() {
        return this.clusterParameterGroupFamily;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterVersion() == null ? 0 : this.clusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.clusterParameterGroupFamily() == null ? 0 : this.clusterParameterGroupFamily().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterVersion)) {
            return false;
        }
        ClusterVersion other = (ClusterVersion)obj;
        if (other.clusterVersion() == null ^ this.clusterVersion() == null) {
            return false;
        }
        if (other.clusterVersion() != null && !other.clusterVersion().equals(this.clusterVersion())) {
            return false;
        }
        if (other.clusterParameterGroupFamily() == null ^ this.clusterParameterGroupFamily() == null) {
            return false;
        }
        if (other.clusterParameterGroupFamily() != null && !other.clusterParameterGroupFamily().equals(this.clusterParameterGroupFamily())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterVersion() != null) {
            sb.append("ClusterVersion: ").append(this.clusterVersion()).append(",");
        }
        if (this.clusterParameterGroupFamily() != null) {
            sb.append("ClusterParameterGroupFamily: ").append(this.clusterParameterGroupFamily()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterVersion;
        private String clusterParameterGroupFamily;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterVersion model) {
            this.setClusterVersion(model.clusterVersion);
            this.setClusterParameterGroupFamily(model.clusterParameterGroupFamily);
            this.setDescription(model.description);
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final String getClusterParameterGroupFamily() {
            return this.clusterParameterGroupFamily;
        }

        @Override
        public final Builder clusterParameterGroupFamily(String clusterParameterGroupFamily) {
            this.clusterParameterGroupFamily = clusterParameterGroupFamily;
            return this;
        }

        public final void setClusterParameterGroupFamily(String clusterParameterGroupFamily) {
            this.clusterParameterGroupFamily = clusterParameterGroupFamily;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public ClusterVersion build() {
            return new ClusterVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterVersion> {
        public Builder clusterVersion(String var1);

        public Builder clusterParameterGroupFamily(String var1);

        public Builder description(String var1);
    }
}

