/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.redshift.model.Subnet;
import software.amazon.awssdk.services.redshift.model.SubnetListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClusterSubnetGroup
implements ToCopyableBuilder<Builder, ClusterSubnetGroup> {
    private final String clusterSubnetGroupName;
    private final String description;
    private final String vpcId;
    private final String subnetGroupStatus;
    private final List<Subnet> subnets;
    private final List<Tag> tags;

    private ClusterSubnetGroup(BuilderImpl builder) {
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.description = builder.description;
        this.vpcId = builder.vpcId;
        this.subnetGroupStatus = builder.subnetGroupStatus;
        this.subnets = builder.subnets;
        this.tags = builder.tags;
    }

    public String clusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public String description() {
        return this.description;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String subnetGroupStatus() {
        return this.subnetGroupStatus;
    }

    public List<Subnet> subnets() {
        return this.subnets;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterSubnetGroupName() == null ? 0 : this.clusterSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.subnetGroupStatus() == null ? 0 : this.subnetGroupStatus().hashCode());
        hashCode = 31 * hashCode + (this.subnets() == null ? 0 : this.subnets().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSubnetGroup)) {
            return false;
        }
        ClusterSubnetGroup other = (ClusterSubnetGroup)obj;
        if (other.clusterSubnetGroupName() == null ^ this.clusterSubnetGroupName() == null) {
            return false;
        }
        if (other.clusterSubnetGroupName() != null && !other.clusterSubnetGroupName().equals(this.clusterSubnetGroupName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.subnetGroupStatus() == null ^ this.subnetGroupStatus() == null) {
            return false;
        }
        if (other.subnetGroupStatus() != null && !other.subnetGroupStatus().equals(this.subnetGroupStatus())) {
            return false;
        }
        if (other.subnets() == null ^ this.subnets() == null) {
            return false;
        }
        if (other.subnets() != null && !other.subnets().equals(this.subnets())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: ").append(this.clusterSubnetGroupName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.subnetGroupStatus() != null) {
            sb.append("SubnetGroupStatus: ").append(this.subnetGroupStatus()).append(",");
        }
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterSubnetGroupName;
        private String description;
        private String vpcId;
        private String subnetGroupStatus;
        private List<Subnet> subnets;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSubnetGroup model) {
            this.setClusterSubnetGroupName(model.clusterSubnetGroupName);
            this.setDescription(model.description);
            this.setVpcId(model.vpcId);
            this.setSubnetGroupStatus(model.subnetGroupStatus);
            this.setSubnets(model.subnets);
            this.setTags(model.tags);
        }

        public final String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getSubnetGroupStatus() {
            return this.subnetGroupStatus;
        }

        @Override
        public final Builder subnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
            return this;
        }

        public final void setSubnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
        }

        public final Collection<Subnet> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public ClusterSubnetGroup build() {
            return new ClusterSubnetGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterSubnetGroup> {
        public Builder clusterSubnetGroupName(String var1);

        public Builder description(String var1);

        public Builder vpcId(String var1);

        public Builder subnetGroupStatus(String var1);

        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

