/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetClusterCredentialsRequestMarshaller
implements Marshaller<Request<GetClusterCredentialsRequest>, GetClusterCredentialsRequest> {
    public Request<GetClusterCredentialsRequest> marshall(GetClusterCredentialsRequest getClusterCredentialsRequest) {
        List<String> dbGroupsList;
        if (getClusterCredentialsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getClusterCredentialsRequest, "RedshiftClient");
        request.addParameter("Action", "GetClusterCredentials");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getClusterCredentialsRequest.dbUser() != null) {
            request.addParameter("DbUser", StringUtils.fromString((String)getClusterCredentialsRequest.dbUser()));
        }
        if (getClusterCredentialsRequest.dbName() != null) {
            request.addParameter("DbName", StringUtils.fromString((String)getClusterCredentialsRequest.dbName()));
        }
        if (getClusterCredentialsRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)getClusterCredentialsRequest.clusterIdentifier()));
        }
        if (getClusterCredentialsRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger((Integer)getClusterCredentialsRequest.durationSeconds()));
        }
        if (getClusterCredentialsRequest.autoCreate() != null) {
            request.addParameter("AutoCreate", StringUtils.fromBoolean((Boolean)getClusterCredentialsRequest.autoCreate()));
        }
        if ((dbGroupsList = getClusterCredentialsRequest.dbGroups()) != null) {
            if (!dbGroupsList.isEmpty()) {
                int dbGroupsListIndex = 1;
                for (String dbGroupsListValue : dbGroupsList) {
                    if (dbGroupsListValue != null) {
                        request.addParameter("DbGroups.DbGroup." + dbGroupsListIndex, StringUtils.fromString((String)dbGroupsListValue));
                    }
                    ++dbGroupsListIndex;
                }
            } else {
                request.addParameter("DbGroups", "");
            }
        }
        return request;
    }
}

