/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeSnapshotCopyGrantsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotCopyGrantsRequest>, DescribeSnapshotCopyGrantsRequest> {
    public Request<DescribeSnapshotCopyGrantsRequest> marshall(DescribeSnapshotCopyGrantsRequest describeSnapshotCopyGrantsRequest) {
        List<String> tagValuesList;
        List<String> tagKeysList;
        if (describeSnapshotCopyGrantsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSnapshotCopyGrantsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeSnapshotCopyGrants");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSnapshotCopyGrantsRequest.snapshotCopyGrantName() != null) {
            request.addParameter("SnapshotCopyGrantName", StringUtils.fromString((String)describeSnapshotCopyGrantsRequest.snapshotCopyGrantName()));
        }
        if (describeSnapshotCopyGrantsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeSnapshotCopyGrantsRequest.maxRecords()));
        }
        if (describeSnapshotCopyGrantsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeSnapshotCopyGrantsRequest.marker()));
        }
        if ((tagKeysList = describeSnapshotCopyGrantsRequest.tagKeys()) != null) {
            if (!tagKeysList.isEmpty()) {
                int tagKeysListIndex = 1;
                for (String tagKeysListValue : tagKeysList) {
                    if (tagKeysListValue != null) {
                        request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                    }
                    ++tagKeysListIndex;
                }
            } else {
                request.addParameter("TagKeys", "");
            }
        }
        if ((tagValuesList = describeSnapshotCopyGrantsRequest.tagValues()) != null) {
            if (!tagValuesList.isEmpty()) {
                int tagValuesListIndex = 1;
                for (String tagValuesListValue : tagValuesList) {
                    if (tagValuesListValue != null) {
                        request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                    }
                    ++tagValuesListIndex;
                }
            } else {
                request.addParameter("TagValues", "");
            }
        }
        return request;
    }
}

