/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.DeleteClusterRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteClusterRequestMarshaller
implements Marshaller<Request<DeleteClusterRequest>, DeleteClusterRequest> {
    public Request<DeleteClusterRequest> marshall(DeleteClusterRequest deleteClusterRequest) {
        if (deleteClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteClusterRequest, "RedshiftClient");
        request.addParameter("Action", "DeleteCluster");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteClusterRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)deleteClusterRequest.clusterIdentifier()));
        }
        if (deleteClusterRequest.skipFinalClusterSnapshot() != null) {
            request.addParameter("SkipFinalClusterSnapshot", StringUtils.fromBoolean((Boolean)deleteClusterRequest.skipFinalClusterSnapshot()));
        }
        if (deleteClusterRequest.finalClusterSnapshotIdentifier() != null) {
            request.addParameter("FinalClusterSnapshotIdentifier", StringUtils.fromString((String)deleteClusterRequest.finalClusterSnapshotIdentifier()));
        }
        return request;
    }
}

