/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateEventSubscriptionRequestMarshaller
implements Marshaller<Request<CreateEventSubscriptionRequest>, CreateEventSubscriptionRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateEventSubscriptionRequest> marshall(CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        List<Tag> tagsList;
        List<String> eventCategoriesList;
        List<String> sourceIdsList;
        if (createEventSubscriptionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createEventSubscriptionRequest, "RedshiftClient");
        request.addParameter("Action", "CreateEventSubscription");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createEventSubscriptionRequest.subscriptionName() != null) {
            request.addParameter("SubscriptionName", StringUtils.fromString((String)createEventSubscriptionRequest.subscriptionName()));
        }
        if (createEventSubscriptionRequest.snsTopicArn() != null) {
            request.addParameter("SnsTopicArn", StringUtils.fromString((String)createEventSubscriptionRequest.snsTopicArn()));
        }
        if (createEventSubscriptionRequest.sourceType() != null) {
            request.addParameter("SourceType", StringUtils.fromString((String)createEventSubscriptionRequest.sourceType()));
        }
        if ((sourceIdsList = createEventSubscriptionRequest.sourceIds()) != null) {
            if (!sourceIdsList.isEmpty()) {
                int sourceIdsListIndex = 1;
                for (String string : sourceIdsList) {
                    if (string != null) {
                        request.addParameter("SourceIds.SourceId." + sourceIdsListIndex, StringUtils.fromString((String)string));
                    }
                    ++sourceIdsListIndex;
                }
            } else {
                request.addParameter("SourceIds", "");
            }
        }
        if ((eventCategoriesList = createEventSubscriptionRequest.eventCategories()) != null) {
            if (!eventCategoriesList.isEmpty()) {
                int eventCategoriesListIndex = 1;
                for (String eventCategoriesListValue : eventCategoriesList) {
                    if (eventCategoriesListValue != null) {
                        request.addParameter("EventCategories.EventCategory." + eventCategoriesListIndex, StringUtils.fromString((String)eventCategoriesListValue));
                    }
                    ++eventCategoriesListIndex;
                }
            } else {
                request.addParameter("EventCategories", "");
            }
        }
        if (createEventSubscriptionRequest.severity() != null) {
            request.addParameter("Severity", StringUtils.fromString((String)createEventSubscriptionRequest.severity()));
        }
        if (createEventSubscriptionRequest.enabled() != null) {
            request.addParameter("Enabled", StringUtils.fromBoolean((Boolean)createEventSubscriptionRequest.enabled()));
        }
        if ((tagsList = createEventSubscriptionRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : tagsList) {
                    void var6_12;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        return request;
    }
}

