/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.PendingModifiedValues;

public class PendingModifiedValuesUnmarshaller
implements Unmarshaller<PendingModifiedValues, StaxUnmarshallerContext> {
    private static PendingModifiedValuesUnmarshaller INSTANCE;

    public PendingModifiedValues unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PendingModifiedValues.Builder pendingModifiedValues = PendingModifiedValues.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MasterUserPassword", targetDepth)) {
                    pendingModifiedValues.masterUserPassword(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NodeType", targetDepth)) {
                    pendingModifiedValues.nodeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NumberOfNodes", targetDepth)) {
                    pendingModifiedValues.numberOfNodes(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterType", targetDepth)) {
                    pendingModifiedValues.clusterType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterVersion", targetDepth)) {
                    pendingModifiedValues.clusterVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutomatedSnapshotRetentionPeriod", targetDepth)) {
                    pendingModifiedValues.automatedSnapshotRetentionPeriod(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterIdentifier", targetDepth)) {
                    pendingModifiedValues.clusterIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PubliclyAccessible", targetDepth)) {
                    pendingModifiedValues.publiclyAccessible(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EnhancedVpcRouting", targetDepth)) continue;
                pendingModifiedValues.enhancedVpcRouting(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PendingModifiedValues)pendingModifiedValues.build();
    }

    public static PendingModifiedValuesUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PendingModifiedValuesUnmarshaller();
        }
        return INSTANCE;
    }
}

