/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateHsmClientCertificateRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateHsmClientCertificateRequest> {
    private final String hsmClientCertificateIdentifier;
    private final List<Tag> tags;

    private CreateHsmClientCertificateRequest(BuilderImpl builder) {
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.tags = builder.tags;
    }

    public String hsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hsmClientCertificateIdentifier() == null ? 0 : this.hsmClientCertificateIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHsmClientCertificateRequest)) {
            return false;
        }
        CreateHsmClientCertificateRequest other = (CreateHsmClientCertificateRequest)((Object)obj);
        if (other.hsmClientCertificateIdentifier() == null ^ this.hsmClientCertificateIdentifier() == null) {
            return false;
        }
        if (other.hsmClientCertificateIdentifier() != null && !other.hsmClientCertificateIdentifier().equals(this.hsmClientCertificateIdentifier())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hsmClientCertificateIdentifier() != null) {
            sb.append("HsmClientCertificateIdentifier: ").append(this.hsmClientCertificateIdentifier()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String hsmClientCertificateIdentifier;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHsmClientCertificateRequest model) {
            this.setHsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            this.setTags(model.tags);
        }

        public final String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public CreateHsmClientCertificateRequest build() {
            return new CreateHsmClientCertificateRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateHsmClientCertificateRequest> {
        public Builder hsmClientCertificateIdentifier(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

