/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.redshift.model.SubnetIdentifierListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateClusterSubnetGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateClusterSubnetGroupRequest> {
    private final String clusterSubnetGroupName;
    private final String description;
    private final List<String> subnetIds;
    private final List<Tag> tags;

    private CreateClusterSubnetGroupRequest(BuilderImpl builder) {
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.description = builder.description;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
    }

    public String clusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public String description() {
        return this.description;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterSubnetGroupName() == null ? 0 : this.clusterSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.subnetIds() == null ? 0 : this.subnetIds().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterSubnetGroupRequest)) {
            return false;
        }
        CreateClusterSubnetGroupRequest other = (CreateClusterSubnetGroupRequest)((Object)obj);
        if (other.clusterSubnetGroupName() == null ^ this.clusterSubnetGroupName() == null) {
            return false;
        }
        if (other.clusterSubnetGroupName() != null && !other.clusterSubnetGroupName().equals(this.clusterSubnetGroupName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.subnetIds() == null ^ this.subnetIds() == null) {
            return false;
        }
        if (other.subnetIds() != null && !other.subnetIds().equals(this.subnetIds())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: ").append(this.clusterSubnetGroupName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterSubnetGroupName;
        private String description;
        private List<String> subnetIds;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterSubnetGroupRequest model) {
            this.setClusterSubnetGroupName(model.clusterSubnetGroupName);
            this.setDescription(model.description);
            this.setSubnetIds(model.subnetIds);
            this.setTags(model.tags);
        }

        public final String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        @SafeVarargs
        public final void setSubnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public CreateClusterSubnetGroupRequest build() {
            return new CreateClusterSubnetGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateClusterSubnetGroupRequest> {
        public Builder clusterSubnetGroupName(String var1);

        public Builder description(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

