/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificate;

public class DescribeHsmClientCertificatesPublisher
implements SdkPublisher<DescribeHsmClientCertificatesResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeHsmClientCertificatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeHsmClientCertificatesPublisher(RedshiftAsyncClient client, DescribeHsmClientCertificatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeHsmClientCertificatesPublisher(RedshiftAsyncClient client, DescribeHsmClientCertificatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeHsmClientCertificatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeHsmClientCertificatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HsmClientCertificate> hsmClientCertificates() {
        Function<DescribeHsmClientCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.hsmClientCertificates() != null) {
                return response.hsmClientCertificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeHsmClientCertificatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeHsmClientCertificatesPublisher resume(DescribeHsmClientCertificatesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeHsmClientCertificatesPublisher(this.client, (DescribeHsmClientCertificatesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeHsmClientCertificatesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeHsmClientCertificatesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeHsmClientCertificatesResponseFetcher
    implements AsyncPageFetcher<DescribeHsmClientCertificatesResponse> {
        private DescribeHsmClientCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHsmClientCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeHsmClientCertificatesResponse> nextPage(DescribeHsmClientCertificatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeHsmClientCertificatesPublisher.this.client.describeHsmClientCertificates(DescribeHsmClientCertificatesPublisher.this.firstRequest);
            }
            return DescribeHsmClientCertificatesPublisher.this.client.describeHsmClientCertificates((DescribeHsmClientCertificatesRequest)((Object)DescribeHsmClientCertificatesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

