/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.Snapshot;

public class DescribeClusterSnapshotsPublisher
implements SdkPublisher<DescribeClusterSnapshotsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeClusterSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClusterSnapshotsPublisher(RedshiftAsyncClient client, DescribeClusterSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClusterSnapshotsPublisher(RedshiftAsyncClient client, DescribeClusterSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClusterSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClusterSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Snapshot> snapshots() {
        Function<DescribeClusterSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshots() != null) {
                return response.snapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeClusterSnapshotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeClusterSnapshotsPublisher resume(DescribeClusterSnapshotsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClusterSnapshotsPublisher(this.client, (DescribeClusterSnapshotsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeClusterSnapshotsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeClusterSnapshotsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeClusterSnapshotsResponseFetcher
    implements AsyncPageFetcher<DescribeClusterSnapshotsResponse> {
        private DescribeClusterSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeClusterSnapshotsResponse> nextPage(DescribeClusterSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterSnapshotsPublisher.this.client.describeClusterSnapshots(DescribeClusterSnapshotsPublisher.this.firstRequest);
            }
            return DescribeClusterSnapshotsPublisher.this.client.describeClusterSnapshots((DescribeClusterSnapshotsRequest)((Object)DescribeClusterSnapshotsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

