/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.waiters.ClusterAvailable;
import software.amazon.awssdk.services.redshift.waiters.ClusterDeleted;
import software.amazon.awssdk.services.redshift.waiters.ClusterRestored;
import software.amazon.awssdk.services.redshift.waiters.DescribeClusterSnapshotsFunction;
import software.amazon.awssdk.services.redshift.waiters.DescribeClustersFunction;
import software.amazon.awssdk.services.redshift.waiters.SnapshotAvailable;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class RedshiftClientWaiters {
    private final RedshiftClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public RedshiftClientWaiters(RedshiftClient client) {
        this.client = client;
    }

    public Waiter<DescribeClustersRequest> clusterDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClustersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ClusterDeleted.IsClusterNotFoundMatcher(), new ClusterDeleted.IsCreatingMatcher(), new ClusterDeleted.IsModifyingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(30), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeClusterSnapshotsRequest> snapshotAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClusterSnapshotsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new SnapshotAvailable.IsAvailableMatcher(), new SnapshotAvailable.IsFailedMatcher(), new SnapshotAvailable.IsDeletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeClustersRequest> clusterRestored() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClustersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ClusterRestored.IsCompletedMatcher(), new ClusterRestored.IsDeletingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(30), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeClustersRequest> clusterAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClustersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ClusterAvailable.IsAvailableMatcher(), new ClusterAvailable.IsDeletingMatcher(), new ClusterAvailable.IsClusterNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(30), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }
}

