/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeClustersRequestMarshaller
implements Marshaller<Request<DescribeClustersRequest>, DescribeClustersRequest> {
    public Request<DescribeClustersRequest> marshall(DescribeClustersRequest describeClustersRequest) {
        SdkInternalList tagValuesList;
        SdkInternalList tagKeysList;
        if (describeClustersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClustersRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusters");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClustersRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)describeClustersRequest.clusterIdentifier()));
        }
        if (describeClustersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeClustersRequest.maxRecords()));
        }
        if (describeClustersRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeClustersRequest.marker()));
        }
        if (!(tagKeysList = (SdkInternalList)describeClustersRequest.tagKeys()).isEmpty() || !tagKeysList.isAutoConstruct()) {
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (!(tagValuesList = (SdkInternalList)describeClustersRequest.tagValues()).isEmpty() || !tagValuesList.isAutoConstruct()) {
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

