/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeClusterSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeClusterSnapshotsRequest>, DescribeClusterSnapshotsRequest> {
    public Request<DescribeClusterSnapshotsRequest> marshall(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) {
        SdkInternalList tagValuesList;
        SdkInternalList tagKeysList;
        if (describeClusterSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClusterSnapshotsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterSnapshots");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterSnapshotsRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)describeClusterSnapshotsRequest.clusterIdentifier()));
        }
        if (describeClusterSnapshotsRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)describeClusterSnapshotsRequest.snapshotIdentifier()));
        }
        if (describeClusterSnapshotsRequest.snapshotType() != null) {
            request.addParameter("SnapshotType", StringUtils.fromString((String)describeClusterSnapshotsRequest.snapshotType()));
        }
        if (describeClusterSnapshotsRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)describeClusterSnapshotsRequest.startTime()));
        }
        if (describeClusterSnapshotsRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)describeClusterSnapshotsRequest.endTime()));
        }
        if (describeClusterSnapshotsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeClusterSnapshotsRequest.maxRecords()));
        }
        if (describeClusterSnapshotsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeClusterSnapshotsRequest.marker()));
        }
        if (describeClusterSnapshotsRequest.ownerAccount() != null) {
            request.addParameter("OwnerAccount", StringUtils.fromString((String)describeClusterSnapshotsRequest.ownerAccount()));
        }
        if (!(tagKeysList = (SdkInternalList)describeClusterSnapshotsRequest.tagKeys()).isEmpty() || !tagKeysList.isAutoConstruct()) {
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (!(tagValuesList = (SdkInternalList)describeClusterSnapshotsRequest.tagValues()).isEmpty() || !tagValuesList.isAutoConstruct()) {
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

