/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeClusterParameterGroupsRequestMarshaller
implements Marshaller<Request<DescribeClusterParameterGroupsRequest>, DescribeClusterParameterGroupsRequest> {
    public Request<DescribeClusterParameterGroupsRequest> marshall(DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) {
        SdkInternalList tagValuesList;
        SdkInternalList tagKeysList;
        if (describeClusterParameterGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClusterParameterGroupsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterParameterGroups");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterParameterGroupsRequest.parameterGroupName() != null) {
            request.addParameter("ParameterGroupName", StringUtils.fromString((String)describeClusterParameterGroupsRequest.parameterGroupName()));
        }
        if (describeClusterParameterGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeClusterParameterGroupsRequest.maxRecords()));
        }
        if (describeClusterParameterGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeClusterParameterGroupsRequest.marker()));
        }
        if (!(tagKeysList = (SdkInternalList)describeClusterParameterGroupsRequest.tagKeys()).isEmpty() || !tagKeysList.isAutoConstruct()) {
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (!(tagValuesList = (SdkInternalList)describeClusterParameterGroupsRequest.tagValues()).isEmpty() || !tagValuesList.isAutoConstruct()) {
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

