/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateHsmConfigurationRequestMarshaller
implements Marshaller<Request<CreateHsmConfigurationRequest>, CreateHsmConfigurationRequest> {
    public Request<CreateHsmConfigurationRequest> marshall(CreateHsmConfigurationRequest createHsmConfigurationRequest) {
        SdkInternalList tagsList;
        if (createHsmConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createHsmConfigurationRequest, "RedshiftClient");
        request.addParameter("Action", "CreateHsmConfiguration");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createHsmConfigurationRequest.hsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString((String)createHsmConfigurationRequest.hsmConfigurationIdentifier()));
        }
        if (createHsmConfigurationRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createHsmConfigurationRequest.description()));
        }
        if (createHsmConfigurationRequest.hsmIpAddress() != null) {
            request.addParameter("HsmIpAddress", StringUtils.fromString((String)createHsmConfigurationRequest.hsmIpAddress()));
        }
        if (createHsmConfigurationRequest.hsmPartitionName() != null) {
            request.addParameter("HsmPartitionName", StringUtils.fromString((String)createHsmConfigurationRequest.hsmPartitionName()));
        }
        if (createHsmConfigurationRequest.hsmPartitionPassword() != null) {
            request.addParameter("HsmPartitionPassword", StringUtils.fromString((String)createHsmConfigurationRequest.hsmPartitionPassword()));
        }
        if (createHsmConfigurationRequest.hsmServerPublicCertificate() != null) {
            request.addParameter("HsmServerPublicCertificate", StringUtils.fromString((String)createHsmConfigurationRequest.hsmServerPublicCertificate()));
        }
        if (!(tagsList = (SdkInternalList)createHsmConfigurationRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

