/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.CreateClusterRequest;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateClusterRequestMarshaller
implements Marshaller<Request<CreateClusterRequest>, CreateClusterRequest> {
    public Request<CreateClusterRequest> marshall(CreateClusterRequest createClusterRequest) {
        SdkInternalList iamRolesList;
        SdkInternalList tagsList;
        SdkInternalList vpcSecurityGroupIdsList;
        SdkInternalList clusterSecurityGroupsList;
        if (createClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createClusterRequest, "RedshiftClient");
        request.addParameter("Action", "CreateCluster");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createClusterRequest.dbName() != null) {
            request.addParameter("DBName", StringUtils.fromString((String)createClusterRequest.dbName()));
        }
        if (createClusterRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)createClusterRequest.clusterIdentifier()));
        }
        if (createClusterRequest.clusterType() != null) {
            request.addParameter("ClusterType", StringUtils.fromString((String)createClusterRequest.clusterType()));
        }
        if (createClusterRequest.nodeType() != null) {
            request.addParameter("NodeType", StringUtils.fromString((String)createClusterRequest.nodeType()));
        }
        if (createClusterRequest.masterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString((String)createClusterRequest.masterUsername()));
        }
        if (createClusterRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)createClusterRequest.masterUserPassword()));
        }
        if (!(clusterSecurityGroupsList = (SdkInternalList)createClusterRequest.clusterSecurityGroups()).isEmpty() || !clusterSecurityGroupsList.isAutoConstruct()) {
            int clusterSecurityGroupsListIndex = 1;
            for (Object clusterSecurityGroupsListValue : clusterSecurityGroupsList) {
                if (clusterSecurityGroupsListValue != null) {
                    request.addParameter("ClusterSecurityGroups.ClusterSecurityGroupName." + clusterSecurityGroupsListIndex, StringUtils.fromString((String)clusterSecurityGroupsListValue));
                }
                ++clusterSecurityGroupsListIndex;
            }
        }
        if (!(vpcSecurityGroupIdsList = (SdkInternalList)createClusterRequest.vpcSecurityGroupIds()).isEmpty() || !vpcSecurityGroupIdsList.isAutoConstruct()) {
            int vpcSecurityGroupIdsListIndex = 1;
            for (Object vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createClusterRequest.clusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringUtils.fromString((String)createClusterRequest.clusterSubnetGroupName()));
        }
        if (createClusterRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createClusterRequest.availabilityZone()));
        }
        if (createClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createClusterRequest.preferredMaintenanceWindow()));
        }
        if (createClusterRequest.clusterParameterGroupName() != null) {
            request.addParameter("ClusterParameterGroupName", StringUtils.fromString((String)createClusterRequest.clusterParameterGroupName()));
        }
        if (createClusterRequest.automatedSnapshotRetentionPeriod() != null) {
            request.addParameter("AutomatedSnapshotRetentionPeriod", StringUtils.fromInteger((Integer)createClusterRequest.automatedSnapshotRetentionPeriod()));
        }
        if (createClusterRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createClusterRequest.port()));
        }
        if (createClusterRequest.clusterVersion() != null) {
            request.addParameter("ClusterVersion", StringUtils.fromString((String)createClusterRequest.clusterVersion()));
        }
        if (createClusterRequest.allowVersionUpgrade() != null) {
            request.addParameter("AllowVersionUpgrade", StringUtils.fromBoolean((Boolean)createClusterRequest.allowVersionUpgrade()));
        }
        if (createClusterRequest.numberOfNodes() != null) {
            request.addParameter("NumberOfNodes", StringUtils.fromInteger((Integer)createClusterRequest.numberOfNodes()));
        }
        if (createClusterRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)createClusterRequest.publiclyAccessible()));
        }
        if (createClusterRequest.encrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean((Boolean)createClusterRequest.encrypted()));
        }
        if (createClusterRequest.hsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString((String)createClusterRequest.hsmClientCertificateIdentifier()));
        }
        if (createClusterRequest.hsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString((String)createClusterRequest.hsmConfigurationIdentifier()));
        }
        if (createClusterRequest.elasticIp() != null) {
            request.addParameter("ElasticIp", StringUtils.fromString((String)createClusterRequest.elasticIp()));
        }
        if (!(tagsList = (SdkInternalList)createClusterRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createClusterRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createClusterRequest.kmsKeyId()));
        }
        if (createClusterRequest.enhancedVpcRouting() != null) {
            request.addParameter("EnhancedVpcRouting", StringUtils.fromBoolean((Boolean)createClusterRequest.enhancedVpcRouting()));
        }
        if (createClusterRequest.additionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString((String)createClusterRequest.additionalInfo()));
        }
        if (!(iamRolesList = (SdkInternalList)createClusterRequest.iamRoles()).isEmpty() || !iamRolesList.isAutoConstruct()) {
            int iamRolesListIndex = 1;
            for (String iamRolesListValue : iamRolesList) {
                if (iamRolesListValue != null) {
                    request.addParameter("IamRoles.IamRoleArn." + iamRolesListIndex, StringUtils.fromString((String)iamRolesListValue));
                }
                ++iamRolesListIndex;
            }
        }
        return request;
    }
}

