/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.services.redshift.model.ClusterIamRole;
import software.amazon.awssdk.services.redshift.model.ClusterNode;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupMembership;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.redshift.transform.ClusterIamRoleUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.ClusterNodeUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.ClusterParameterGroupStatusUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.ClusterSecurityGroupMembershipUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.ClusterSnapshotCopyStatusUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.ElasticIpStatusUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.EndpointUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.HsmStatusUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.PendingModifiedValuesUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.RestoreStatusUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.TagUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.VpcSecurityGroupMembershipUnmarshaller;

public class ClusterUnmarshaller
implements Unmarshaller<Cluster, StaxUnmarshallerContext> {
    private static ClusterUnmarshaller INSTANCE;

    public Cluster unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Cluster.Builder cluster = Cluster.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ClusterIdentifier", targetDepth)) {
                    cluster.clusterIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NodeType", targetDepth)) {
                    cluster.nodeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterStatus", targetDepth)) {
                    cluster.clusterStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ModifyStatus", targetDepth)) {
                    cluster.modifyStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MasterUsername", targetDepth)) {
                    cluster.masterUsername(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBName", targetDepth)) {
                    cluster.dbName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Endpoint", targetDepth)) {
                    cluster.endpoint(EndpointUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterCreateTime", targetDepth)) {
                    cluster.clusterCreateTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutomatedSnapshotRetentionPeriod", targetDepth)) {
                    cluster.automatedSnapshotRetentionPeriod(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterSecurityGroups", targetDepth)) {
                    cluster.clusterSecurityGroups(new ArrayList<ClusterSecurityGroupMembership>());
                    continue;
                }
                if (context.testExpression("ClusterSecurityGroups/ClusterSecurityGroup", targetDepth)) {
                    cluster.clusterSecurityGroups(ClusterSecurityGroupMembershipUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcSecurityGroups", targetDepth)) {
                    cluster.vpcSecurityGroups(new ArrayList<VpcSecurityGroupMembership>());
                    continue;
                }
                if (context.testExpression("VpcSecurityGroups/VpcSecurityGroup", targetDepth)) {
                    cluster.vpcSecurityGroups(VpcSecurityGroupMembershipUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterParameterGroups", targetDepth)) {
                    cluster.clusterParameterGroups(new ArrayList<ClusterParameterGroupStatus>());
                    continue;
                }
                if (context.testExpression("ClusterParameterGroups/ClusterParameterGroup", targetDepth)) {
                    cluster.clusterParameterGroups(ClusterParameterGroupStatusUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterSubnetGroupName", targetDepth)) {
                    cluster.clusterSubnetGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcId", targetDepth)) {
                    cluster.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AvailabilityZone", targetDepth)) {
                    cluster.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredMaintenanceWindow", targetDepth)) {
                    cluster.preferredMaintenanceWindow(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PendingModifiedValues", targetDepth)) {
                    cluster.pendingModifiedValues(PendingModifiedValuesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterVersion", targetDepth)) {
                    cluster.clusterVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllowVersionUpgrade", targetDepth)) {
                    cluster.allowVersionUpgrade(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NumberOfNodes", targetDepth)) {
                    cluster.numberOfNodes(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PubliclyAccessible", targetDepth)) {
                    cluster.publiclyAccessible(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Encrypted", targetDepth)) {
                    cluster.encrypted(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RestoreStatus", targetDepth)) {
                    cluster.restoreStatus(RestoreStatusUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HsmStatus", targetDepth)) {
                    cluster.hsmStatus(HsmStatusUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterSnapshotCopyStatus", targetDepth)) {
                    cluster.clusterSnapshotCopyStatus(ClusterSnapshotCopyStatusUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterPublicKey", targetDepth)) {
                    cluster.clusterPublicKey(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterNodes", targetDepth)) {
                    cluster.clusterNodes(new ArrayList<ClusterNode>());
                    continue;
                }
                if (context.testExpression("ClusterNodes/member", targetDepth)) {
                    cluster.clusterNodes(ClusterNodeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ElasticIpStatus", targetDepth)) {
                    cluster.elasticIpStatus(ElasticIpStatusUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterRevisionNumber", targetDepth)) {
                    cluster.clusterRevisionNumber(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    cluster.tags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("Tags/Tag", targetDepth)) {
                    cluster.tags(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    cluster.kmsKeyId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EnhancedVpcRouting", targetDepth)) {
                    cluster.enhancedVpcRouting(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IamRoles", targetDepth)) {
                    cluster.iamRoles(new ArrayList<ClusterIamRole>());
                    continue;
                }
                if (!context.testExpression("IamRoles/ClusterIamRole", targetDepth)) continue;
                cluster.iamRoles(ClusterIamRoleUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Cluster)cluster.build();
    }

    public static ClusterUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClusterUnmarshaller();
        }
        return INSTANCE;
    }
}

