/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SnapshotCopyGrant
implements ToCopyableBuilder<Builder, SnapshotCopyGrant> {
    private final String snapshotCopyGrantName;
    private final String kmsKeyId;
    private final List<Tag> tags;

    private SnapshotCopyGrant(BuilderImpl builder) {
        this.snapshotCopyGrantName = builder.snapshotCopyGrantName;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
    }

    public String snapshotCopyGrantName() {
        return this.snapshotCopyGrantName;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.snapshotCopyGrantName() == null ? 0 : this.snapshotCopyGrantName().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotCopyGrant)) {
            return false;
        }
        SnapshotCopyGrant other = (SnapshotCopyGrant)obj;
        if (other.snapshotCopyGrantName() == null ^ this.snapshotCopyGrantName() == null) {
            return false;
        }
        if (other.snapshotCopyGrantName() != null && !other.snapshotCopyGrantName().equals(this.snapshotCopyGrantName())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.snapshotCopyGrantName() != null) {
            sb.append("SnapshotCopyGrantName: ").append(this.snapshotCopyGrantName()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String snapshotCopyGrantName;
        private String kmsKeyId;
        private List<Tag> tags = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotCopyGrant model) {
            this.setSnapshotCopyGrantName(model.snapshotCopyGrantName);
            this.setKmsKeyId(model.kmsKeyId);
            this.setTags(model.tags);
        }

        public final String getSnapshotCopyGrantName() {
            return this.snapshotCopyGrantName;
        }

        @Override
        public final Builder snapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
            return this;
        }

        public final void setSnapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public SnapshotCopyGrant build() {
            return new SnapshotCopyGrant(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SnapshotCopyGrant> {
        public Builder snapshotCopyGrantName(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

