/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.redshift.model.DbGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetClusterCredentialsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetClusterCredentialsRequest> {
    private final String dbUser;
    private final String dbName;
    private final String clusterIdentifier;
    private final Integer durationSeconds;
    private final Boolean autoCreate;
    private final List<String> dbGroups;

    private GetClusterCredentialsRequest(BuilderImpl builder) {
        this.dbUser = builder.dbUser;
        this.dbName = builder.dbName;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.durationSeconds = builder.durationSeconds;
        this.autoCreate = builder.autoCreate;
        this.dbGroups = builder.dbGroups;
    }

    public String dbUser() {
        return this.dbUser;
    }

    public String dbName() {
        return this.dbName;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Integer durationSeconds() {
        return this.durationSeconds;
    }

    public Boolean autoCreate() {
        return this.autoCreate;
    }

    public List<String> dbGroups() {
        return this.dbGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbUser() == null ? 0 : this.dbUser().hashCode());
        hashCode = 31 * hashCode + (this.dbName() == null ? 0 : this.dbName().hashCode());
        hashCode = 31 * hashCode + (this.clusterIdentifier() == null ? 0 : this.clusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.durationSeconds() == null ? 0 : this.durationSeconds().hashCode());
        hashCode = 31 * hashCode + (this.autoCreate() == null ? 0 : this.autoCreate().hashCode());
        hashCode = 31 * hashCode + (this.dbGroups() == null ? 0 : this.dbGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterCredentialsRequest)) {
            return false;
        }
        GetClusterCredentialsRequest other = (GetClusterCredentialsRequest)((Object)obj);
        if (other.dbUser() == null ^ this.dbUser() == null) {
            return false;
        }
        if (other.dbUser() != null && !other.dbUser().equals(this.dbUser())) {
            return false;
        }
        if (other.dbName() == null ^ this.dbName() == null) {
            return false;
        }
        if (other.dbName() != null && !other.dbName().equals(this.dbName())) {
            return false;
        }
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        if (other.durationSeconds() == null ^ this.durationSeconds() == null) {
            return false;
        }
        if (other.durationSeconds() != null && !other.durationSeconds().equals(this.durationSeconds())) {
            return false;
        }
        if (other.autoCreate() == null ^ this.autoCreate() == null) {
            return false;
        }
        if (other.autoCreate() != null && !other.autoCreate().equals(this.autoCreate())) {
            return false;
        }
        if (other.dbGroups() == null ^ this.dbGroups() == null) {
            return false;
        }
        return other.dbGroups() == null || other.dbGroups().equals(this.dbGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbUser() != null) {
            sb.append("DbUser: ").append(this.dbUser()).append(",");
        }
        if (this.dbName() != null) {
            sb.append("DbName: ").append(this.dbName()).append(",");
        }
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.durationSeconds() != null) {
            sb.append("DurationSeconds: ").append(this.durationSeconds()).append(",");
        }
        if (this.autoCreate() != null) {
            sb.append("AutoCreate: ").append(this.autoCreate()).append(",");
        }
        if (this.dbGroups() != null) {
            sb.append("DbGroups: ").append(this.dbGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbUser;
        private String dbName;
        private String clusterIdentifier;
        private Integer durationSeconds;
        private Boolean autoCreate;
        private List<String> dbGroups = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterCredentialsRequest model) {
            this.setDbUser(model.dbUser);
            this.setDbName(model.dbName);
            this.setClusterIdentifier(model.clusterIdentifier);
            this.setDurationSeconds(model.durationSeconds);
            this.setAutoCreate(model.autoCreate);
            this.setDbGroups(model.dbGroups);
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getDbName() {
            return this.dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        public final Boolean getAutoCreate() {
            return this.autoCreate;
        }

        @Override
        public final Builder autoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
            return this;
        }

        public final void setAutoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        public final Collection<String> getDbGroups() {
            return this.dbGroups;
        }

        @Override
        public final Builder dbGroups(Collection<String> dbGroups) {
            this.dbGroups = DbGroupListCopier.copy(dbGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbGroups(String ... dbGroups) {
            if (this.dbGroups == null) {
                this.dbGroups = new SdkInternalList(dbGroups.length);
            }
            for (String e : dbGroups) {
                this.dbGroups.add(e);
            }
            return this;
        }

        public final void setDbGroups(Collection<String> dbGroups) {
            this.dbGroups = DbGroupListCopier.copy(dbGroups);
        }

        @SafeVarargs
        public final void setDbGroups(String ... dbGroups) {
            if (this.dbGroups == null) {
                this.dbGroups = new SdkInternalList(dbGroups.length);
            }
            for (String e : dbGroups) {
                this.dbGroups.add(e);
            }
        }

        public GetClusterCredentialsRequest build() {
            return new GetClusterCredentialsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetClusterCredentialsRequest> {
        public Builder dbUser(String var1);

        public Builder dbName(String var1);

        public Builder clusterIdentifier(String var1);

        public Builder durationSeconds(Integer var1);

        public Builder autoCreate(Boolean var1);

        public Builder dbGroups(Collection<String> var1);

        public Builder dbGroups(String ... var1);
    }
}

