/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.services.redshift.model.ClusterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClustersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeClustersResponse> {
    private final String marker;
    private final List<Cluster> clusters;

    private DescribeClustersResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.clusters = builder.clusters;
    }

    public String marker() {
        return this.marker;
    }

    public List<Cluster> clusters() {
        return this.clusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.clusters() == null ? 0 : this.clusters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersResponse)) {
            return false;
        }
        DescribeClustersResponse other = (DescribeClustersResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.clusters() == null ^ this.clusters() == null) {
            return false;
        }
        return other.clusters() == null || other.clusters().equals(this.clusters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.clusters() != null) {
            sb.append("Clusters: ").append(this.clusters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<Cluster> clusters = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClustersResponse model) {
            this.setMarker(model.marker);
            this.setClusters(model.clusters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Cluster> getClusters() {
            return this.clusters;
        }

        @Override
        public final Builder clusters(Collection<Cluster> clusters) {
            this.clusters = ClusterListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Cluster ... clusters) {
            if (this.clusters == null) {
                this.clusters = new SdkInternalList(clusters.length);
            }
            for (Cluster e : clusters) {
                this.clusters.add(e);
            }
            return this;
        }

        public final void setClusters(Collection<Cluster> clusters) {
            this.clusters = ClusterListCopier.copy(clusters);
        }

        @SafeVarargs
        public final void setClusters(Cluster ... clusters) {
            if (this.clusters == null) {
                this.clusters = new SdkInternalList(clusters.length);
            }
            for (Cluster e : clusters) {
                this.clusters.add(e);
            }
        }

        public DescribeClustersResponse build() {
            return new DescribeClustersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeClustersResponse> {
        public Builder marker(String var1);

        public Builder clusters(Collection<Cluster> var1);

        public Builder clusters(Cluster ... var1);
    }
}

