/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.redshift.model.ClusterIamRole;
import software.amazon.awssdk.services.redshift.model.ClusterIamRoleListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterNode;
import software.amazon.awssdk.services.redshift.model.ClusterNodesListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatusListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupMembership;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotCopyStatus;
import software.amazon.awssdk.services.redshift.model.ElasticIpStatus;
import software.amazon.awssdk.services.redshift.model.Endpoint;
import software.amazon.awssdk.services.redshift.model.HsmStatus;
import software.amazon.awssdk.services.redshift.model.PendingModifiedValues;
import software.amazon.awssdk.services.redshift.model.RestoreStatus;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Cluster
implements ToCopyableBuilder<Builder, Cluster> {
    private final String clusterIdentifier;
    private final String nodeType;
    private final String clusterStatus;
    private final String modifyStatus;
    private final String masterUsername;
    private final String dbName;
    private final Endpoint endpoint;
    private final Date clusterCreateTime;
    private final Integer automatedSnapshotRetentionPeriod;
    private final List<ClusterSecurityGroupMembership> clusterSecurityGroups;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private final List<ClusterParameterGroupStatus> clusterParameterGroups;
    private final String clusterSubnetGroupName;
    private final String vpcId;
    private final String availabilityZone;
    private final String preferredMaintenanceWindow;
    private final PendingModifiedValues pendingModifiedValues;
    private final String clusterVersion;
    private final Boolean allowVersionUpgrade;
    private final Integer numberOfNodes;
    private final Boolean publiclyAccessible;
    private final Boolean encrypted;
    private final RestoreStatus restoreStatus;
    private final HsmStatus hsmStatus;
    private final ClusterSnapshotCopyStatus clusterSnapshotCopyStatus;
    private final String clusterPublicKey;
    private final List<ClusterNode> clusterNodes;
    private final ElasticIpStatus elasticIpStatus;
    private final String clusterRevisionNumber;
    private final List<Tag> tags;
    private final String kmsKeyId;
    private final Boolean enhancedVpcRouting;
    private final List<ClusterIamRole> iamRoles;

    private Cluster(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.nodeType = builder.nodeType;
        this.clusterStatus = builder.clusterStatus;
        this.modifyStatus = builder.modifyStatus;
        this.masterUsername = builder.masterUsername;
        this.dbName = builder.dbName;
        this.endpoint = builder.endpoint;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.clusterParameterGroups = builder.clusterParameterGroups;
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.vpcId = builder.vpcId;
        this.availabilityZone = builder.availabilityZone;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.clusterVersion = builder.clusterVersion;
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.numberOfNodes = builder.numberOfNodes;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.encrypted = builder.encrypted;
        this.restoreStatus = builder.restoreStatus;
        this.hsmStatus = builder.hsmStatus;
        this.clusterSnapshotCopyStatus = builder.clusterSnapshotCopyStatus;
        this.clusterPublicKey = builder.clusterPublicKey;
        this.clusterNodes = builder.clusterNodes;
        this.elasticIpStatus = builder.elasticIpStatus;
        this.clusterRevisionNumber = builder.clusterRevisionNumber;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.iamRoles = builder.iamRoles;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public String clusterStatus() {
        return this.clusterStatus;
    }

    public String modifyStatus() {
        return this.modifyStatus;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String dbName() {
        return this.dbName;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public Date clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public Integer automatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public List<ClusterSecurityGroupMembership> clusterSecurityGroups() {
        return this.clusterSecurityGroups;
    }

    public List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public List<ClusterParameterGroupStatus> clusterParameterGroups() {
        return this.clusterParameterGroups;
    }

    public String clusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public PendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public Boolean allowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public RestoreStatus restoreStatus() {
        return this.restoreStatus;
    }

    public HsmStatus hsmStatus() {
        return this.hsmStatus;
    }

    public ClusterSnapshotCopyStatus clusterSnapshotCopyStatus() {
        return this.clusterSnapshotCopyStatus;
    }

    public String clusterPublicKey() {
        return this.clusterPublicKey;
    }

    public List<ClusterNode> clusterNodes() {
        return this.clusterNodes;
    }

    public ElasticIpStatus elasticIpStatus() {
        return this.elasticIpStatus;
    }

    public String clusterRevisionNumber() {
        return this.clusterRevisionNumber;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public List<ClusterIamRole> iamRoles() {
        return this.iamRoles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterIdentifier() == null ? 0 : this.clusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.nodeType() == null ? 0 : this.nodeType().hashCode());
        hashCode = 31 * hashCode + (this.clusterStatus() == null ? 0 : this.clusterStatus().hashCode());
        hashCode = 31 * hashCode + (this.modifyStatus() == null ? 0 : this.modifyStatus().hashCode());
        hashCode = 31 * hashCode + (this.masterUsername() == null ? 0 : this.masterUsername().hashCode());
        hashCode = 31 * hashCode + (this.dbName() == null ? 0 : this.dbName().hashCode());
        hashCode = 31 * hashCode + (this.endpoint() == null ? 0 : this.endpoint().hashCode());
        hashCode = 31 * hashCode + (this.clusterCreateTime() == null ? 0 : this.clusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.automatedSnapshotRetentionPeriod() == null ? 0 : this.automatedSnapshotRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.clusterSecurityGroups() == null ? 0 : this.clusterSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.vpcSecurityGroups() == null ? 0 : this.vpcSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.clusterParameterGroups() == null ? 0 : this.clusterParameterGroups().hashCode());
        hashCode = 31 * hashCode + (this.clusterSubnetGroupName() == null ? 0 : this.clusterSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.pendingModifiedValues() == null ? 0 : this.pendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.clusterVersion() == null ? 0 : this.clusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.allowVersionUpgrade() == null ? 0 : this.allowVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.numberOfNodes() == null ? 0 : this.numberOfNodes().hashCode());
        hashCode = 31 * hashCode + (this.publiclyAccessible() == null ? 0 : this.publiclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.encrypted() == null ? 0 : this.encrypted().hashCode());
        hashCode = 31 * hashCode + (this.restoreStatus() == null ? 0 : this.restoreStatus().hashCode());
        hashCode = 31 * hashCode + (this.hsmStatus() == null ? 0 : this.hsmStatus().hashCode());
        hashCode = 31 * hashCode + (this.clusterSnapshotCopyStatus() == null ? 0 : this.clusterSnapshotCopyStatus().hashCode());
        hashCode = 31 * hashCode + (this.clusterPublicKey() == null ? 0 : this.clusterPublicKey().hashCode());
        hashCode = 31 * hashCode + (this.clusterNodes() == null ? 0 : this.clusterNodes().hashCode());
        hashCode = 31 * hashCode + (this.elasticIpStatus() == null ? 0 : this.elasticIpStatus().hashCode());
        hashCode = 31 * hashCode + (this.clusterRevisionNumber() == null ? 0 : this.clusterRevisionNumber().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.enhancedVpcRouting() == null ? 0 : this.enhancedVpcRouting().hashCode());
        hashCode = 31 * hashCode + (this.iamRoles() == null ? 0 : this.iamRoles().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        if (other.nodeType() == null ^ this.nodeType() == null) {
            return false;
        }
        if (other.nodeType() != null && !other.nodeType().equals(this.nodeType())) {
            return false;
        }
        if (other.clusterStatus() == null ^ this.clusterStatus() == null) {
            return false;
        }
        if (other.clusterStatus() != null && !other.clusterStatus().equals(this.clusterStatus())) {
            return false;
        }
        if (other.modifyStatus() == null ^ this.modifyStatus() == null) {
            return false;
        }
        if (other.modifyStatus() != null && !other.modifyStatus().equals(this.modifyStatus())) {
            return false;
        }
        if (other.masterUsername() == null ^ this.masterUsername() == null) {
            return false;
        }
        if (other.masterUsername() != null && !other.masterUsername().equals(this.masterUsername())) {
            return false;
        }
        if (other.dbName() == null ^ this.dbName() == null) {
            return false;
        }
        if (other.dbName() != null && !other.dbName().equals(this.dbName())) {
            return false;
        }
        if (other.endpoint() == null ^ this.endpoint() == null) {
            return false;
        }
        if (other.endpoint() != null && !other.endpoint().equals(this.endpoint())) {
            return false;
        }
        if (other.clusterCreateTime() == null ^ this.clusterCreateTime() == null) {
            return false;
        }
        if (other.clusterCreateTime() != null && !other.clusterCreateTime().equals(this.clusterCreateTime())) {
            return false;
        }
        if (other.automatedSnapshotRetentionPeriod() == null ^ this.automatedSnapshotRetentionPeriod() == null) {
            return false;
        }
        if (other.automatedSnapshotRetentionPeriod() != null && !other.automatedSnapshotRetentionPeriod().equals(this.automatedSnapshotRetentionPeriod())) {
            return false;
        }
        if (other.clusterSecurityGroups() == null ^ this.clusterSecurityGroups() == null) {
            return false;
        }
        if (other.clusterSecurityGroups() != null && !other.clusterSecurityGroups().equals(this.clusterSecurityGroups())) {
            return false;
        }
        if (other.vpcSecurityGroups() == null ^ this.vpcSecurityGroups() == null) {
            return false;
        }
        if (other.vpcSecurityGroups() != null && !other.vpcSecurityGroups().equals(this.vpcSecurityGroups())) {
            return false;
        }
        if (other.clusterParameterGroups() == null ^ this.clusterParameterGroups() == null) {
            return false;
        }
        if (other.clusterParameterGroups() != null && !other.clusterParameterGroups().equals(this.clusterParameterGroups())) {
            return false;
        }
        if (other.clusterSubnetGroupName() == null ^ this.clusterSubnetGroupName() == null) {
            return false;
        }
        if (other.clusterSubnetGroupName() != null && !other.clusterSubnetGroupName().equals(this.clusterSubnetGroupName())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.pendingModifiedValues() == null ^ this.pendingModifiedValues() == null) {
            return false;
        }
        if (other.pendingModifiedValues() != null && !other.pendingModifiedValues().equals(this.pendingModifiedValues())) {
            return false;
        }
        if (other.clusterVersion() == null ^ this.clusterVersion() == null) {
            return false;
        }
        if (other.clusterVersion() != null && !other.clusterVersion().equals(this.clusterVersion())) {
            return false;
        }
        if (other.allowVersionUpgrade() == null ^ this.allowVersionUpgrade() == null) {
            return false;
        }
        if (other.allowVersionUpgrade() != null && !other.allowVersionUpgrade().equals(this.allowVersionUpgrade())) {
            return false;
        }
        if (other.numberOfNodes() == null ^ this.numberOfNodes() == null) {
            return false;
        }
        if (other.numberOfNodes() != null && !other.numberOfNodes().equals(this.numberOfNodes())) {
            return false;
        }
        if (other.publiclyAccessible() == null ^ this.publiclyAccessible() == null) {
            return false;
        }
        if (other.publiclyAccessible() != null && !other.publiclyAccessible().equals(this.publiclyAccessible())) {
            return false;
        }
        if (other.encrypted() == null ^ this.encrypted() == null) {
            return false;
        }
        if (other.encrypted() != null && !other.encrypted().equals(this.encrypted())) {
            return false;
        }
        if (other.restoreStatus() == null ^ this.restoreStatus() == null) {
            return false;
        }
        if (other.restoreStatus() != null && !other.restoreStatus().equals(this.restoreStatus())) {
            return false;
        }
        if (other.hsmStatus() == null ^ this.hsmStatus() == null) {
            return false;
        }
        if (other.hsmStatus() != null && !other.hsmStatus().equals(this.hsmStatus())) {
            return false;
        }
        if (other.clusterSnapshotCopyStatus() == null ^ this.clusterSnapshotCopyStatus() == null) {
            return false;
        }
        if (other.clusterSnapshotCopyStatus() != null && !other.clusterSnapshotCopyStatus().equals(this.clusterSnapshotCopyStatus())) {
            return false;
        }
        if (other.clusterPublicKey() == null ^ this.clusterPublicKey() == null) {
            return false;
        }
        if (other.clusterPublicKey() != null && !other.clusterPublicKey().equals(this.clusterPublicKey())) {
            return false;
        }
        if (other.clusterNodes() == null ^ this.clusterNodes() == null) {
            return false;
        }
        if (other.clusterNodes() != null && !other.clusterNodes().equals(this.clusterNodes())) {
            return false;
        }
        if (other.elasticIpStatus() == null ^ this.elasticIpStatus() == null) {
            return false;
        }
        if (other.elasticIpStatus() != null && !other.elasticIpStatus().equals(this.elasticIpStatus())) {
            return false;
        }
        if (other.clusterRevisionNumber() == null ^ this.clusterRevisionNumber() == null) {
            return false;
        }
        if (other.clusterRevisionNumber() != null && !other.clusterRevisionNumber().equals(this.clusterRevisionNumber())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.enhancedVpcRouting() == null ^ this.enhancedVpcRouting() == null) {
            return false;
        }
        if (other.enhancedVpcRouting() != null && !other.enhancedVpcRouting().equals(this.enhancedVpcRouting())) {
            return false;
        }
        if (other.iamRoles() == null ^ this.iamRoles() == null) {
            return false;
        }
        return other.iamRoles() == null || other.iamRoles().equals(this.iamRoles());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.nodeType() != null) {
            sb.append("NodeType: ").append(this.nodeType()).append(",");
        }
        if (this.clusterStatus() != null) {
            sb.append("ClusterStatus: ").append(this.clusterStatus()).append(",");
        }
        if (this.modifyStatus() != null) {
            sb.append("ModifyStatus: ").append(this.modifyStatus()).append(",");
        }
        if (this.masterUsername() != null) {
            sb.append("MasterUsername: ").append(this.masterUsername()).append(",");
        }
        if (this.dbName() != null) {
            sb.append("DBName: ").append(this.dbName()).append(",");
        }
        if (this.endpoint() != null) {
            sb.append("Endpoint: ").append(this.endpoint()).append(",");
        }
        if (this.clusterCreateTime() != null) {
            sb.append("ClusterCreateTime: ").append(this.clusterCreateTime()).append(",");
        }
        if (this.automatedSnapshotRetentionPeriod() != null) {
            sb.append("AutomatedSnapshotRetentionPeriod: ").append(this.automatedSnapshotRetentionPeriod()).append(",");
        }
        if (this.clusterSecurityGroups() != null) {
            sb.append("ClusterSecurityGroups: ").append(this.clusterSecurityGroups()).append(",");
        }
        if (this.vpcSecurityGroups() != null) {
            sb.append("VpcSecurityGroups: ").append(this.vpcSecurityGroups()).append(",");
        }
        if (this.clusterParameterGroups() != null) {
            sb.append("ClusterParameterGroups: ").append(this.clusterParameterGroups()).append(",");
        }
        if (this.clusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: ").append(this.clusterSubnetGroupName()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.pendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.pendingModifiedValues()).append(",");
        }
        if (this.clusterVersion() != null) {
            sb.append("ClusterVersion: ").append(this.clusterVersion()).append(",");
        }
        if (this.allowVersionUpgrade() != null) {
            sb.append("AllowVersionUpgrade: ").append(this.allowVersionUpgrade()).append(",");
        }
        if (this.numberOfNodes() != null) {
            sb.append("NumberOfNodes: ").append(this.numberOfNodes()).append(",");
        }
        if (this.publiclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.publiclyAccessible()).append(",");
        }
        if (this.encrypted() != null) {
            sb.append("Encrypted: ").append(this.encrypted()).append(",");
        }
        if (this.restoreStatus() != null) {
            sb.append("RestoreStatus: ").append(this.restoreStatus()).append(",");
        }
        if (this.hsmStatus() != null) {
            sb.append("HsmStatus: ").append(this.hsmStatus()).append(",");
        }
        if (this.clusterSnapshotCopyStatus() != null) {
            sb.append("ClusterSnapshotCopyStatus: ").append(this.clusterSnapshotCopyStatus()).append(",");
        }
        if (this.clusterPublicKey() != null) {
            sb.append("ClusterPublicKey: ").append(this.clusterPublicKey()).append(",");
        }
        if (this.clusterNodes() != null) {
            sb.append("ClusterNodes: ").append(this.clusterNodes()).append(",");
        }
        if (this.elasticIpStatus() != null) {
            sb.append("ElasticIpStatus: ").append(this.elasticIpStatus()).append(",");
        }
        if (this.clusterRevisionNumber() != null) {
            sb.append("ClusterRevisionNumber: ").append(this.clusterRevisionNumber()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.enhancedVpcRouting() != null) {
            sb.append("EnhancedVpcRouting: ").append(this.enhancedVpcRouting()).append(",");
        }
        if (this.iamRoles() != null) {
            sb.append("IamRoles: ").append(this.iamRoles()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String nodeType;
        private String clusterStatus;
        private String modifyStatus;
        private String masterUsername;
        private String dbName;
        private Endpoint endpoint;
        private Date clusterCreateTime;
        private Integer automatedSnapshotRetentionPeriod;
        private List<ClusterSecurityGroupMembership> clusterSecurityGroups = new SdkInternalList();
        private List<VpcSecurityGroupMembership> vpcSecurityGroups = new SdkInternalList();
        private List<ClusterParameterGroupStatus> clusterParameterGroups = new SdkInternalList();
        private String clusterSubnetGroupName;
        private String vpcId;
        private String availabilityZone;
        private String preferredMaintenanceWindow;
        private PendingModifiedValues pendingModifiedValues;
        private String clusterVersion;
        private Boolean allowVersionUpgrade;
        private Integer numberOfNodes;
        private Boolean publiclyAccessible;
        private Boolean encrypted;
        private RestoreStatus restoreStatus;
        private HsmStatus hsmStatus;
        private ClusterSnapshotCopyStatus clusterSnapshotCopyStatus;
        private String clusterPublicKey;
        private List<ClusterNode> clusterNodes = new SdkInternalList();
        private ElasticIpStatus elasticIpStatus;
        private String clusterRevisionNumber;
        private List<Tag> tags = new SdkInternalList();
        private String kmsKeyId;
        private Boolean enhancedVpcRouting;
        private List<ClusterIamRole> iamRoles = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.setClusterIdentifier(model.clusterIdentifier);
            this.setNodeType(model.nodeType);
            this.setClusterStatus(model.clusterStatus);
            this.setModifyStatus(model.modifyStatus);
            this.setMasterUsername(model.masterUsername);
            this.setDBName(model.dbName);
            this.setEndpoint(model.endpoint);
            this.setClusterCreateTime(model.clusterCreateTime);
            this.setAutomatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            this.setClusterSecurityGroups(model.clusterSecurityGroups);
            this.setVpcSecurityGroups(model.vpcSecurityGroups);
            this.setClusterParameterGroups(model.clusterParameterGroups);
            this.setClusterSubnetGroupName(model.clusterSubnetGroupName);
            this.setVpcId(model.vpcId);
            this.setAvailabilityZone(model.availabilityZone);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setPendingModifiedValues(model.pendingModifiedValues);
            this.setClusterVersion(model.clusterVersion);
            this.setAllowVersionUpgrade(model.allowVersionUpgrade);
            this.setNumberOfNodes(model.numberOfNodes);
            this.setPubliclyAccessible(model.publiclyAccessible);
            this.setEncrypted(model.encrypted);
            this.setRestoreStatus(model.restoreStatus);
            this.setHsmStatus(model.hsmStatus);
            this.setClusterSnapshotCopyStatus(model.clusterSnapshotCopyStatus);
            this.setClusterPublicKey(model.clusterPublicKey);
            this.setClusterNodes(model.clusterNodes);
            this.setElasticIpStatus(model.elasticIpStatus);
            this.setClusterRevisionNumber(model.clusterRevisionNumber);
            this.setTags(model.tags);
            this.setKmsKeyId(model.kmsKeyId);
            this.setEnhancedVpcRouting(model.enhancedVpcRouting);
            this.setIamRoles(model.iamRoles);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final String getClusterStatus() {
            return this.clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        public final String getModifyStatus() {
            return this.modifyStatus;
        }

        @Override
        public final Builder modifyStatus(String modifyStatus) {
            this.modifyStatus = modifyStatus;
            return this;
        }

        public final void setModifyStatus(String modifyStatus) {
            this.modifyStatus = modifyStatus;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getDBName() {
            return this.dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDBName(String dbName) {
            this.dbName = dbName;
        }

        public final Endpoint getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public final Date getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Date clusterCreateTime) {
            this.clusterCreateTime = StandardMemberCopier.copy((Date)clusterCreateTime);
            return this;
        }

        public final void setClusterCreateTime(Date clusterCreateTime) {
            this.clusterCreateTime = StandardMemberCopier.copy((Date)clusterCreateTime);
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return this.automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        public final Collection<ClusterSecurityGroupMembership> getClusterSecurityGroups() {
            return this.clusterSecurityGroups;
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<ClusterSecurityGroupMembership> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupMembershipListCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(ClusterSecurityGroupMembership ... clusterSecurityGroups) {
            if (this.clusterSecurityGroups == null) {
                this.clusterSecurityGroups = new SdkInternalList(clusterSecurityGroups.length);
            }
            for (ClusterSecurityGroupMembership e : clusterSecurityGroups) {
                this.clusterSecurityGroups.add(e);
            }
            return this;
        }

        public final void setClusterSecurityGroups(Collection<ClusterSecurityGroupMembership> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupMembershipListCopier.copy(clusterSecurityGroups);
        }

        @SafeVarargs
        public final void setClusterSecurityGroups(ClusterSecurityGroupMembership ... clusterSecurityGroups) {
            if (this.clusterSecurityGroups == null) {
                this.clusterSecurityGroups = new SdkInternalList(clusterSecurityGroups.length);
            }
            for (ClusterSecurityGroupMembership e : clusterSecurityGroups) {
                this.clusterSecurityGroups.add(e);
            }
        }

        public final Collection<VpcSecurityGroupMembership> getVpcSecurityGroups() {
            return this.vpcSecurityGroups;
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            if (this.vpcSecurityGroups == null) {
                this.vpcSecurityGroups = new SdkInternalList(vpcSecurityGroups.length);
            }
            for (VpcSecurityGroupMembership e : vpcSecurityGroups) {
                this.vpcSecurityGroups.add(e);
            }
            return this;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
        }

        @SafeVarargs
        public final void setVpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            if (this.vpcSecurityGroups == null) {
                this.vpcSecurityGroups = new SdkInternalList(vpcSecurityGroups.length);
            }
            for (VpcSecurityGroupMembership e : vpcSecurityGroups) {
                this.vpcSecurityGroups.add(e);
            }
        }

        public final Collection<ClusterParameterGroupStatus> getClusterParameterGroups() {
            return this.clusterParameterGroups;
        }

        @Override
        public final Builder clusterParameterGroups(Collection<ClusterParameterGroupStatus> clusterParameterGroups) {
            this.clusterParameterGroups = ClusterParameterGroupStatusListCopier.copy(clusterParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterParameterGroups(ClusterParameterGroupStatus ... clusterParameterGroups) {
            if (this.clusterParameterGroups == null) {
                this.clusterParameterGroups = new SdkInternalList(clusterParameterGroups.length);
            }
            for (ClusterParameterGroupStatus e : clusterParameterGroups) {
                this.clusterParameterGroups.add(e);
            }
            return this;
        }

        public final void setClusterParameterGroups(Collection<ClusterParameterGroupStatus> clusterParameterGroups) {
            this.clusterParameterGroups = ClusterParameterGroupStatusListCopier.copy(clusterParameterGroups);
        }

        @SafeVarargs
        public final void setClusterParameterGroups(ClusterParameterGroupStatus ... clusterParameterGroups) {
            if (this.clusterParameterGroups == null) {
                this.clusterParameterGroups = new SdkInternalList(clusterParameterGroups.length);
            }
            for (ClusterParameterGroupStatus e : clusterParameterGroups) {
                this.clusterParameterGroups.add(e);
            }
        }

        public final String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final PendingModifiedValues getPendingModifiedValues() {
            return this.pendingModifiedValues;
        }

        @Override
        public final Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final Boolean getAllowVersionUpgrade() {
            return this.allowVersionUpgrade;
        }

        @Override
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final RestoreStatus getRestoreStatus() {
            return this.restoreStatus;
        }

        @Override
        public final Builder restoreStatus(RestoreStatus restoreStatus) {
            this.restoreStatus = restoreStatus;
            return this;
        }

        public final void setRestoreStatus(RestoreStatus restoreStatus) {
            this.restoreStatus = restoreStatus;
        }

        public final HsmStatus getHsmStatus() {
            return this.hsmStatus;
        }

        @Override
        public final Builder hsmStatus(HsmStatus hsmStatus) {
            this.hsmStatus = hsmStatus;
            return this;
        }

        public final void setHsmStatus(HsmStatus hsmStatus) {
            this.hsmStatus = hsmStatus;
        }

        public final ClusterSnapshotCopyStatus getClusterSnapshotCopyStatus() {
            return this.clusterSnapshotCopyStatus;
        }

        @Override
        public final Builder clusterSnapshotCopyStatus(ClusterSnapshotCopyStatus clusterSnapshotCopyStatus) {
            this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus;
            return this;
        }

        public final void setClusterSnapshotCopyStatus(ClusterSnapshotCopyStatus clusterSnapshotCopyStatus) {
            this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus;
        }

        public final String getClusterPublicKey() {
            return this.clusterPublicKey;
        }

        @Override
        public final Builder clusterPublicKey(String clusterPublicKey) {
            this.clusterPublicKey = clusterPublicKey;
            return this;
        }

        public final void setClusterPublicKey(String clusterPublicKey) {
            this.clusterPublicKey = clusterPublicKey;
        }

        public final Collection<ClusterNode> getClusterNodes() {
            return this.clusterNodes;
        }

        @Override
        public final Builder clusterNodes(Collection<ClusterNode> clusterNodes) {
            this.clusterNodes = ClusterNodesListCopier.copy(clusterNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodes(ClusterNode ... clusterNodes) {
            if (this.clusterNodes == null) {
                this.clusterNodes = new SdkInternalList(clusterNodes.length);
            }
            for (ClusterNode e : clusterNodes) {
                this.clusterNodes.add(e);
            }
            return this;
        }

        public final void setClusterNodes(Collection<ClusterNode> clusterNodes) {
            this.clusterNodes = ClusterNodesListCopier.copy(clusterNodes);
        }

        @SafeVarargs
        public final void setClusterNodes(ClusterNode ... clusterNodes) {
            if (this.clusterNodes == null) {
                this.clusterNodes = new SdkInternalList(clusterNodes.length);
            }
            for (ClusterNode e : clusterNodes) {
                this.clusterNodes.add(e);
            }
        }

        public final ElasticIpStatus getElasticIpStatus() {
            return this.elasticIpStatus;
        }

        @Override
        public final Builder elasticIpStatus(ElasticIpStatus elasticIpStatus) {
            this.elasticIpStatus = elasticIpStatus;
            return this;
        }

        public final void setElasticIpStatus(ElasticIpStatus elasticIpStatus) {
            this.elasticIpStatus = elasticIpStatus;
        }

        public final String getClusterRevisionNumber() {
            return this.clusterRevisionNumber;
        }

        @Override
        public final Builder clusterRevisionNumber(String clusterRevisionNumber) {
            this.clusterRevisionNumber = clusterRevisionNumber;
            return this;
        }

        public final void setClusterRevisionNumber(String clusterRevisionNumber) {
            this.clusterRevisionNumber = clusterRevisionNumber;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        public final Collection<ClusterIamRole> getIamRoles() {
            return this.iamRoles;
        }

        @Override
        public final Builder iamRoles(Collection<ClusterIamRole> iamRoles) {
            this.iamRoles = ClusterIamRoleListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(ClusterIamRole ... iamRoles) {
            if (this.iamRoles == null) {
                this.iamRoles = new SdkInternalList(iamRoles.length);
            }
            for (ClusterIamRole e : iamRoles) {
                this.iamRoles.add(e);
            }
            return this;
        }

        public final void setIamRoles(Collection<ClusterIamRole> iamRoles) {
            this.iamRoles = ClusterIamRoleListCopier.copy(iamRoles);
        }

        @SafeVarargs
        public final void setIamRoles(ClusterIamRole ... iamRoles) {
            if (this.iamRoles == null) {
                this.iamRoles = new SdkInternalList(iamRoles.length);
            }
            for (ClusterIamRole e : iamRoles) {
                this.iamRoles.add(e);
            }
        }

        public Cluster build() {
            return new Cluster(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Cluster> {
        public Builder clusterIdentifier(String var1);

        public Builder nodeType(String var1);

        public Builder clusterStatus(String var1);

        public Builder modifyStatus(String var1);

        public Builder masterUsername(String var1);

        public Builder dbName(String var1);

        public Builder endpoint(Endpoint var1);

        public Builder clusterCreateTime(Date var1);

        public Builder automatedSnapshotRetentionPeriod(Integer var1);

        public Builder clusterSecurityGroups(Collection<ClusterSecurityGroupMembership> var1);

        public Builder clusterSecurityGroups(ClusterSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroups(VpcSecurityGroupMembership ... var1);

        public Builder clusterParameterGroups(Collection<ClusterParameterGroupStatus> var1);

        public Builder clusterParameterGroups(ClusterParameterGroupStatus ... var1);

        public Builder clusterSubnetGroupName(String var1);

        public Builder vpcId(String var1);

        public Builder availabilityZone(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder pendingModifiedValues(PendingModifiedValues var1);

        public Builder clusterVersion(String var1);

        public Builder allowVersionUpgrade(Boolean var1);

        public Builder numberOfNodes(Integer var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder encrypted(Boolean var1);

        public Builder restoreStatus(RestoreStatus var1);

        public Builder hsmStatus(HsmStatus var1);

        public Builder clusterSnapshotCopyStatus(ClusterSnapshotCopyStatus var1);

        public Builder clusterPublicKey(String var1);

        public Builder clusterNodes(Collection<ClusterNode> var1);

        public Builder clusterNodes(ClusterNode ... var1);

        public Builder elasticIpStatus(ElasticIpStatus var1);

        public Builder clusterRevisionNumber(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder kmsKeyId(String var1);

        public Builder enhancedVpcRouting(Boolean var1);

        public Builder iamRoles(Collection<ClusterIamRole> var1);

        public Builder iamRoles(ClusterIamRole ... var1);
    }
}

