/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Field implements SdkPojo, Serializable, ToCopyableBuilder<Field.Builder, Field> {
    private static final SdkField<Boolean> IS_NULL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isNull").getter(getter(Field::isNull)).setter(setter(Builder::isNull))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNull").build()).build();

    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("booleanValue").getter(getter(Field::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()).build();

    private static final SdkField<Long> LONG_VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("longValue")
            .getter(getter(Field::longValue)).setter(setter(Builder::longValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longValue").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("doubleValue").getter(getter(Field::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stringValue").getter(getter(Field::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<SdkBytes> BLOB_VALUE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("blobValue").getter(getter(Field::blobValue)).setter(setter(Builder::blobValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobValue").build()).build();

    private static final SdkField<ArrayValue> ARRAY_VALUE_FIELD = SdkField.<ArrayValue> builder(MarshallingType.SDK_POJO)
            .memberName("arrayValue").getter(getter(Field::arrayValue)).setter(setter(Builder::arrayValue))
            .constructor(ArrayValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_NULL_FIELD,
            BOOLEAN_VALUE_FIELD, LONG_VALUE_FIELD, DOUBLE_VALUE_FIELD, STRING_VALUE_FIELD, BLOB_VALUE_FIELD, ARRAY_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isNull;

    private final Boolean booleanValue;

    private final Long longValue;

    private final Double doubleValue;

    private final String stringValue;

    private final SdkBytes blobValue;

    private final ArrayValue arrayValue;

    private final Type type;

    private Field(BuilderImpl builder) {
        this.isNull = builder.isNull;
        this.booleanValue = builder.booleanValue;
        this.longValue = builder.longValue;
        this.doubleValue = builder.doubleValue;
        this.stringValue = builder.stringValue;
        this.blobValue = builder.blobValue;
        this.arrayValue = builder.arrayValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * A NULL value.
     * </p>
     * 
     * @return A NULL value.
     */
    public final Boolean isNull() {
        return isNull;
    }

    /**
     * <p>
     * A value of Boolean data type.
     * </p>
     * 
     * @return A value of Boolean data type.
     */
    public final Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * A value of long data type.
     * </p>
     * 
     * @return A value of long data type.
     */
    public final Long longValue() {
        return longValue;
    }

    /**
     * <p>
     * A value of double data type.
     * </p>
     * 
     * @return A value of double data type.
     */
    public final Double doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * A value of string data type.
     * </p>
     * 
     * @return A value of string data type.
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * A value of BLOB data type.
     * </p>
     * 
     * @return A value of BLOB data type.
     */
    public final SdkBytes blobValue() {
        return blobValue;
    }

    /**
     * <p>
     * An array of values.
     * </p>
     * 
     * @return An array of values.
     */
    public final ArrayValue arrayValue() {
        return arrayValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isNull());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(longValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(blobValue());
        hashCode = 31 * hashCode + Objects.hashCode(arrayValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field) obj;
        return Objects.equals(isNull(), other.isNull()) && Objects.equals(booleanValue(), other.booleanValue())
                && Objects.equals(longValue(), other.longValue()) && Objects.equals(doubleValue(), other.doubleValue())
                && Objects.equals(stringValue(), other.stringValue()) && Objects.equals(blobValue(), other.blobValue())
                && Objects.equals(arrayValue(), other.arrayValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Field").add("IsNull", isNull()).add("BooleanValue", booleanValue())
                .add("LongValue", longValue()).add("DoubleValue", doubleValue()).add("StringValue", stringValue())
                .add("BlobValue", blobValue()).add("ArrayValue", arrayValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isNull":
            return Optional.ofNullable(clazz.cast(isNull()));
        case "booleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "longValue":
            return Optional.ofNullable(clazz.cast(longValue()));
        case "doubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "blobValue":
            return Optional.ofNullable(clazz.cast(blobValue()));
        case "arrayValue":
            return Optional.ofNullable(clazz.cast(arrayValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #isNull()} initialized to the given value.
     *
     * <p>
     * A NULL value.
     * </p>
     * 
     * @param isNull
     *        A NULL value.
     */
    public static Field fromIsNull(Boolean isNull) {
        return builder().isNull(isNull).build();
    }

    /**
     * Create an instance of this class with {@link #booleanValue()} initialized to the given value.
     *
     * <p>
     * A value of Boolean data type.
     * </p>
     * 
     * @param booleanValue
     *        A value of Boolean data type.
     */
    public static Field fromBooleanValue(Boolean booleanValue) {
        return builder().booleanValue(booleanValue).build();
    }

    /**
     * Create an instance of this class with {@link #longValue()} initialized to the given value.
     *
     * <p>
     * A value of long data type.
     * </p>
     * 
     * @param longValue
     *        A value of long data type.
     */
    public static Field fromLongValue(Long longValue) {
        return builder().longValue(longValue).build();
    }

    /**
     * Create an instance of this class with {@link #doubleValue()} initialized to the given value.
     *
     * <p>
     * A value of double data type.
     * </p>
     * 
     * @param doubleValue
     *        A value of double data type.
     */
    public static Field fromDoubleValue(Double doubleValue) {
        return builder().doubleValue(doubleValue).build();
    }

    /**
     * Create an instance of this class with {@link #stringValue()} initialized to the given value.
     *
     * <p>
     * A value of string data type.
     * </p>
     * 
     * @param stringValue
     *        A value of string data type.
     */
    public static Field fromStringValue(String stringValue) {
        return builder().stringValue(stringValue).build();
    }

    /**
     * Create an instance of this class with {@link #blobValue()} initialized to the given value.
     *
     * <p>
     * A value of BLOB data type.
     * </p>
     * 
     * @param blobValue
     *        A value of BLOB data type.
     */
    public static Field fromBlobValue(SdkBytes blobValue) {
        return builder().blobValue(blobValue).build();
    }

    /**
     * Create an instance of this class with {@link #arrayValue()} initialized to the given value.
     *
     * <p>
     * An array of values.
     * </p>
     * 
     * @param arrayValue
     *        An array of values.
     */
    public static Field fromArrayValue(ArrayValue arrayValue) {
        return builder().arrayValue(arrayValue).build();
    }

    /**
     * Create an instance of this class with {@link #arrayValue()} initialized to the given value.
     *
     * <p>
     * An array of values.
     * </p>
     * 
     * @param arrayValue
     *        An array of values.
     */
    public static Field fromArrayValue(Consumer<ArrayValue.Builder> arrayValue) {
        ArrayValue.Builder builder = ArrayValue.builder();
        arrayValue.accept(builder);
        return fromArrayValue(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Field, T> g) {
        return obj -> g.apply((Field) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Field> {
        /**
         * <p>
         * A NULL value.
         * </p>
         * 
         * @param isNull
         *        A NULL value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNull(Boolean isNull);

        /**
         * <p>
         * A value of Boolean data type.
         * </p>
         * 
         * @param booleanValue
         *        A value of Boolean data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * A value of long data type.
         * </p>
         * 
         * @param longValue
         *        A value of long data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longValue(Long longValue);

        /**
         * <p>
         * A value of double data type.
         * </p>
         * 
         * @param doubleValue
         *        A value of double data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * <p>
         * A value of string data type.
         * </p>
         * 
         * @param stringValue
         *        A value of string data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * A value of BLOB data type.
         * </p>
         * 
         * @param blobValue
         *        A value of BLOB data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blobValue(SdkBytes blobValue);

        /**
         * <p>
         * An array of values.
         * </p>
         * 
         * @param arrayValue
         *        An array of values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayValue(ArrayValue arrayValue);

        /**
         * <p>
         * An array of values.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArrayValue.Builder} avoiding the need to
         * create one manually via {@link ArrayValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArrayValue.Builder#build()} is called immediately and its result
         * is passed to {@link #arrayValue(ArrayValue)}.
         * 
         * @param arrayValue
         *        a consumer that will call methods on {@link ArrayValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrayValue(ArrayValue)
         */
        default Builder arrayValue(Consumer<ArrayValue.Builder> arrayValue) {
            return arrayValue(ArrayValue.builder().applyMutation(arrayValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean isNull;

        private Boolean booleanValue;

        private Long longValue;

        private Double doubleValue;

        private String stringValue;

        private SdkBytes blobValue;

        private ArrayValue arrayValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Field model) {
            isNull(model.isNull);
            booleanValue(model.booleanValue);
            longValue(model.longValue);
            doubleValue(model.doubleValue);
            stringValue(model.stringValue);
            blobValue(model.blobValue);
            arrayValue(model.arrayValue);
        }

        public final Boolean getIsNull() {
            return isNull;
        }

        public final void setIsNull(Boolean isNull) {
            Object oldValue = this.isNull;
            this.isNull = isNull;
            handleUnionValueChange(Type.IS_NULL, oldValue, this.isNull);
        }

        @Override
        public final Builder isNull(Boolean isNull) {
            Object oldValue = this.isNull;
            this.isNull = isNull;
            handleUnionValueChange(Type.IS_NULL, oldValue, this.isNull);
            return this;
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public final Long getLongValue() {
            return longValue;
        }

        public final void setLongValue(Long longValue) {
            Object oldValue = this.longValue;
            this.longValue = longValue;
            handleUnionValueChange(Type.LONG_VALUE, oldValue, this.longValue);
        }

        @Override
        public final Builder longValue(Long longValue) {
            Object oldValue = this.longValue;
            this.longValue = longValue;
            handleUnionValueChange(Type.LONG_VALUE, oldValue, this.longValue);
            return this;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
            return this;
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final ByteBuffer getBlobValue() {
            return blobValue == null ? null : blobValue.asByteBuffer();
        }

        public final void setBlobValue(ByteBuffer blobValue) {
            blobValue(blobValue == null ? null : SdkBytes.fromByteBuffer(blobValue));
        }

        @Override
        public final Builder blobValue(SdkBytes blobValue) {
            Object oldValue = this.blobValue;
            this.blobValue = blobValue;
            handleUnionValueChange(Type.BLOB_VALUE, oldValue, this.blobValue);
            return this;
        }

        public final ArrayValue.Builder getArrayValue() {
            return arrayValue != null ? arrayValue.toBuilder() : null;
        }

        public final void setArrayValue(ArrayValue.BuilderImpl arrayValue) {
            Object oldValue = this.arrayValue;
            this.arrayValue = arrayValue != null ? arrayValue.build() : null;
            handleUnionValueChange(Type.ARRAY_VALUE, oldValue, this.arrayValue);
        }

        @Override
        public final Builder arrayValue(ArrayValue arrayValue) {
            Object oldValue = this.arrayValue;
            this.arrayValue = arrayValue;
            handleUnionValueChange(Type.ARRAY_VALUE, oldValue, this.arrayValue);
            return this;
        }

        @Override
        public Field build() {
            return new Field(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Field#type()
     */
    public enum Type {
        IS_NULL,

        BOOLEAN_VALUE,

        LONG_VALUE,

        DOUBLE_VALUE,

        STRING_VALUE,

        BLOB_VALUE,

        ARRAY_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
