/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.ValidVolumeOptions;
import software.amazon.awssdk.services.rds.model.ValidVolumeOptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidAdditionalStorageOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidAdditionalStorageOptions> {
    private static final SdkField<Boolean> SUPPORTS_ADDITIONAL_STORAGE_VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsAdditionalStorageVolumes").getter(ValidAdditionalStorageOptions.getter(ValidAdditionalStorageOptions::supportsAdditionalStorageVolumes)).setter(ValidAdditionalStorageOptions.setter(Builder::supportsAdditionalStorageVolumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsAdditionalStorageVolumes").build()}).build();
    private static final SdkField<List<ValidVolumeOptions>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Volumes").getter(ValidAdditionalStorageOptions.getter(ValidAdditionalStorageOptions::volumes)).setter(ValidAdditionalStorageOptions.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidVolumeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTS_ADDITIONAL_STORAGE_VOLUMES_FIELD, VOLUMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidAdditionalStorageOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean supportsAdditionalStorageVolumes;
    private final List<ValidVolumeOptions> volumes;

    private ValidAdditionalStorageOptions(BuilderImpl builder) {
        this.supportsAdditionalStorageVolumes = builder.supportsAdditionalStorageVolumes;
        this.volumes = builder.volumes;
    }

    public final Boolean supportsAdditionalStorageVolumes() {
        return this.supportsAdditionalStorageVolumes;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<ValidVolumeOptions> volumes() {
        return this.volumes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsAdditionalStorageVolumes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidAdditionalStorageOptions)) {
            return false;
        }
        ValidAdditionalStorageOptions other = (ValidAdditionalStorageOptions)obj;
        return Objects.equals(this.supportsAdditionalStorageVolumes(), other.supportsAdditionalStorageVolumes()) && this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes());
    }

    public final String toString() {
        return ToString.builder((String)"ValidAdditionalStorageOptions").add("SupportsAdditionalStorageVolumes", (Object)this.supportsAdditionalStorageVolumes()).add("Volumes", this.hasVolumes() ? this.volumes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SupportsAdditionalStorageVolumes": {
                return Optional.ofNullable(clazz.cast(this.supportsAdditionalStorageVolumes()));
            }
            case "Volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SupportsAdditionalStorageVolumes", SUPPORTS_ADDITIONAL_STORAGE_VOLUMES_FIELD);
        map.put("Volumes", VOLUMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidAdditionalStorageOptions, T> g) {
        return obj -> g.apply((ValidAdditionalStorageOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean supportsAdditionalStorageVolumes;
        private List<ValidVolumeOptions> volumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidAdditionalStorageOptions model) {
            this.supportsAdditionalStorageVolumes(model.supportsAdditionalStorageVolumes);
            this.volumes(model.volumes);
        }

        public final Boolean getSupportsAdditionalStorageVolumes() {
            return this.supportsAdditionalStorageVolumes;
        }

        public final void setSupportsAdditionalStorageVolumes(Boolean supportsAdditionalStorageVolumes) {
            this.supportsAdditionalStorageVolumes = supportsAdditionalStorageVolumes;
        }

        @Override
        public final Builder supportsAdditionalStorageVolumes(Boolean supportsAdditionalStorageVolumes) {
            this.supportsAdditionalStorageVolumes = supportsAdditionalStorageVolumes;
            return this;
        }

        public final List<ValidVolumeOptions.Builder> getVolumes() {
            List<ValidVolumeOptions.Builder> result = ValidVolumeOptionsListCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<ValidVolumeOptions.BuilderImpl> volumes) {
            this.volumes = ValidVolumeOptionsListCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<ValidVolumeOptions> volumes) {
            this.volumes = ValidVolumeOptionsListCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(ValidVolumeOptions ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<ValidVolumeOptions.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (ValidVolumeOptions)((ValidVolumeOptions.Builder)ValidVolumeOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ValidAdditionalStorageOptions build() {
            return new ValidAdditionalStorageOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidAdditionalStorageOptions> {
        public Builder supportsAdditionalStorageVolumes(Boolean var1);

        public Builder volumes(Collection<ValidVolumeOptions> var1);

        public Builder volumes(ValidVolumeOptions ... var1);

        public Builder volumes(Consumer<ValidVolumeOptions.Builder> ... var1);
    }
}

