/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOptionGroupsRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, DescribeOptionGroupsRequest> {
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeOptionGroupsRequest.getter(DescribeOptionGroupsRequest::optionGroupName)).setter(DescribeOptionGroupsRequest.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeOptionGroupsRequest.getter(DescribeOptionGroupsRequest::filters)).setter(DescribeOptionGroupsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeOptionGroupsRequest.getter(DescribeOptionGroupsRequest::marker)).setter(DescribeOptionGroupsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeOptionGroupsRequest.getter(DescribeOptionGroupsRequest::maxRecords)).setter(DescribeOptionGroupsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeOptionGroupsRequest.getter(DescribeOptionGroupsRequest::engineName)).setter(DescribeOptionGroupsRequest.setter(Builder::engineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()}).build();
    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeOptionGroupsRequest.getter(DescribeOptionGroupsRequest::majorEngineVersion)).setter(DescribeOptionGroupsRequest.setter(Builder::majorEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_GROUP_NAME_FIELD, FILTERS_FIELD, MARKER_FIELD, MAX_RECORDS_FIELD, ENGINE_NAME_FIELD, MAJOR_ENGINE_VERSION_FIELD));
    private final String optionGroupName;
    private final List<Filter> filters;
    private final String marker;
    private final Integer maxRecords;
    private final String engineName;
    private final String majorEngineVersion;

    private DescribeOptionGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.optionGroupName = builder.optionGroupName;
        this.filters = builder.filters;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
        this.engineName = builder.engineName;
        this.majorEngineVersion = builder.majorEngineVersion;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String engineName() {
        return this.engineName;
    }

    public String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorEngineVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptionGroupsRequest)) {
            return false;
        }
        DescribeOptionGroupsRequest other = (DescribeOptionGroupsRequest)((Object)obj);
        return Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.engineName(), other.engineName()) && Objects.equals(this.majorEngineVersion(), other.majorEngineVersion());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOptionGroupsRequest").add("OptionGroupName", (Object)this.optionGroupName()).add("Filters", this.filters()).add("Marker", (Object)this.marker()).add("MaxRecords", (Object)this.maxRecords()).add("EngineName", (Object)this.engineName()).add("MajorEngineVersion", (Object)this.majorEngineVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "EngineName": {
                return Optional.ofNullable(clazz.cast(this.engineName()));
            }
            case "MajorEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.majorEngineVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOptionGroupsRequest, T> g) {
        return obj -> g.apply((DescribeOptionGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String optionGroupName;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Integer maxRecords;
        private String engineName;
        private String majorEngineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptionGroupsRequest model) {
            super(model);
            this.optionGroupName(model.optionGroupName);
            this.filters(model.filters);
            this.marker(model.marker);
            this.maxRecords(model.maxRecords);
            this.engineName(model.engineName);
            this.majorEngineVersion(model.majorEngineVersion);
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOptionGroupsRequest build() {
            return new DescribeOptionGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOptionGroupsRequest> {
        public Builder optionGroupName(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder marker(String var1);

        public Builder maxRecords(Integer var1);

        public Builder engineName(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

