/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBMajorEngineVersion;
import software.amazon.awssdk.services.rds.model.DBMajorEngineVersionsListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbMajorEngineVersionsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbMajorEngineVersionsResponse> {
    private static final SdkField<List<DBMajorEngineVersion>> DB_MAJOR_ENGINE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBMajorEngineVersions").getter(DescribeDbMajorEngineVersionsResponse.getter(DescribeDbMajorEngineVersionsResponse::dbMajorEngineVersions)).setter(DescribeDbMajorEngineVersionsResponse.setter(Builder::dbMajorEngineVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBMajorEngineVersions").build(), ListTrait.builder().memberLocationName("DBMajorEngineVersion").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBMajorEngineVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBMajorEngineVersion").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbMajorEngineVersionsResponse.getter(DescribeDbMajorEngineVersionsResponse::marker)).setter(DescribeDbMajorEngineVersionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_MAJOR_ENGINE_VERSIONS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDbMajorEngineVersionsResponse.memberNameToFieldInitializer();
    private final List<DBMajorEngineVersion> dbMajorEngineVersions;
    private final String marker;

    private DescribeDbMajorEngineVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.dbMajorEngineVersions = builder.dbMajorEngineVersions;
        this.marker = builder.marker;
    }

    public final boolean hasDbMajorEngineVersions() {
        return this.dbMajorEngineVersions != null && !(this.dbMajorEngineVersions instanceof SdkAutoConstructList);
    }

    public final List<DBMajorEngineVersion> dbMajorEngineVersions() {
        return this.dbMajorEngineVersions;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbMajorEngineVersions() ? this.dbMajorEngineVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbMajorEngineVersionsResponse)) {
            return false;
        }
        DescribeDbMajorEngineVersionsResponse other = (DescribeDbMajorEngineVersionsResponse)((Object)obj);
        return this.hasDbMajorEngineVersions() == other.hasDbMajorEngineVersions() && Objects.equals(this.dbMajorEngineVersions(), other.dbMajorEngineVersions()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbMajorEngineVersionsResponse").add("DBMajorEngineVersions", this.hasDbMajorEngineVersions() ? this.dbMajorEngineVersions() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBMajorEngineVersions": {
                return Optional.ofNullable(clazz.cast(this.dbMajorEngineVersions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBMajorEngineVersions", DB_MAJOR_ENGINE_VERSIONS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbMajorEngineVersionsResponse, T> g) {
        return obj -> g.apply((DescribeDbMajorEngineVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<DBMajorEngineVersion> dbMajorEngineVersions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbMajorEngineVersionsResponse model) {
            super(model);
            this.dbMajorEngineVersions(model.dbMajorEngineVersions);
            this.marker(model.marker);
        }

        public final List<DBMajorEngineVersion.Builder> getDbMajorEngineVersions() {
            List<DBMajorEngineVersion.Builder> result = DBMajorEngineVersionsListCopier.copyToBuilder(this.dbMajorEngineVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbMajorEngineVersions(Collection<DBMajorEngineVersion.BuilderImpl> dbMajorEngineVersions) {
            this.dbMajorEngineVersions = DBMajorEngineVersionsListCopier.copyFromBuilder(dbMajorEngineVersions);
        }

        @Override
        public final Builder dbMajorEngineVersions(Collection<DBMajorEngineVersion> dbMajorEngineVersions) {
            this.dbMajorEngineVersions = DBMajorEngineVersionsListCopier.copy(dbMajorEngineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbMajorEngineVersions(DBMajorEngineVersion ... dbMajorEngineVersions) {
            this.dbMajorEngineVersions(Arrays.asList(dbMajorEngineVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbMajorEngineVersions(Consumer<DBMajorEngineVersion.Builder> ... dbMajorEngineVersions) {
            this.dbMajorEngineVersions(Stream.of(dbMajorEngineVersions).map(c -> (DBMajorEngineVersion)((DBMajorEngineVersion.Builder)DBMajorEngineVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeDbMajorEngineVersionsResponse build() {
            return new DescribeDbMajorEngineVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbMajorEngineVersionsResponse> {
        public Builder dbMajorEngineVersions(Collection<DBMajorEngineVersion> var1);

        public Builder dbMajorEngineVersions(DBMajorEngineVersion ... var1);

        public Builder dbMajorEngineVersions(Consumer<DBMajorEngineVersion.Builder> ... var1);

        public Builder marker(String var1);
    }
}

