/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbShardGroupRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyDbShardGroupRequest> {
    private static final SdkField<String> DB_SHARD_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBShardGroupIdentifier").getter(ModifyDbShardGroupRequest.getter(ModifyDbShardGroupRequest::dbShardGroupIdentifier)).setter(ModifyDbShardGroupRequest.setter(Builder::dbShardGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBShardGroupIdentifier").build()}).build();
    private static final SdkField<Double> MAX_ACU_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxACU").getter(ModifyDbShardGroupRequest.getter(ModifyDbShardGroupRequest::maxACU)).setter(ModifyDbShardGroupRequest.setter(Builder::maxACU)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxACU").build()}).build();
    private static final SdkField<Double> MIN_ACU_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinACU").getter(ModifyDbShardGroupRequest.getter(ModifyDbShardGroupRequest::minACU)).setter(ModifyDbShardGroupRequest.setter(Builder::minACU)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinACU").build()}).build();
    private static final SdkField<Integer> COMPUTE_REDUNDANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ComputeRedundancy").getter(ModifyDbShardGroupRequest.getter(ModifyDbShardGroupRequest::computeRedundancy)).setter(ModifyDbShardGroupRequest.setter(Builder::computeRedundancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeRedundancy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SHARD_GROUP_IDENTIFIER_FIELD, MAX_ACU_FIELD, MIN_ACU_FIELD, COMPUTE_REDUNDANCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyDbShardGroupRequest.memberNameToFieldInitializer();
    private final String dbShardGroupIdentifier;
    private final Double maxACU;
    private final Double minACU;
    private final Integer computeRedundancy;

    private ModifyDbShardGroupRequest(BuilderImpl builder) {
        super(builder);
        this.dbShardGroupIdentifier = builder.dbShardGroupIdentifier;
        this.maxACU = builder.maxACU;
        this.minACU = builder.minACU;
        this.computeRedundancy = builder.computeRedundancy;
    }

    public final String dbShardGroupIdentifier() {
        return this.dbShardGroupIdentifier;
    }

    public final Double maxACU() {
        return this.maxACU;
    }

    public final Double minACU() {
        return this.minACU;
    }

    public final Integer computeRedundancy() {
        return this.computeRedundancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbShardGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxACU());
        hashCode = 31 * hashCode + Objects.hashCode(this.minACU());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeRedundancy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbShardGroupRequest)) {
            return false;
        }
        ModifyDbShardGroupRequest other = (ModifyDbShardGroupRequest)((Object)obj);
        return Objects.equals(this.dbShardGroupIdentifier(), other.dbShardGroupIdentifier()) && Objects.equals(this.maxACU(), other.maxACU()) && Objects.equals(this.minACU(), other.minACU()) && Objects.equals(this.computeRedundancy(), other.computeRedundancy());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDbShardGroupRequest").add("DBShardGroupIdentifier", (Object)this.dbShardGroupIdentifier()).add("MaxACU", (Object)this.maxACU()).add("MinACU", (Object)this.minACU()).add("ComputeRedundancy", (Object)this.computeRedundancy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBShardGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbShardGroupIdentifier()));
            }
            case "MaxACU": {
                return Optional.ofNullable(clazz.cast(this.maxACU()));
            }
            case "MinACU": {
                return Optional.ofNullable(clazz.cast(this.minACU()));
            }
            case "ComputeRedundancy": {
                return Optional.ofNullable(clazz.cast(this.computeRedundancy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBShardGroupIdentifier", DB_SHARD_GROUP_IDENTIFIER_FIELD);
        map.put("MaxACU", MAX_ACU_FIELD);
        map.put("MinACU", MIN_ACU_FIELD);
        map.put("ComputeRedundancy", COMPUTE_REDUNDANCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbShardGroupRequest, T> g) {
        return obj -> g.apply((ModifyDbShardGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbShardGroupIdentifier;
        private Double maxACU;
        private Double minACU;
        private Integer computeRedundancy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbShardGroupRequest model) {
            super(model);
            this.dbShardGroupIdentifier(model.dbShardGroupIdentifier);
            this.maxACU(model.maxACU);
            this.minACU(model.minACU);
            this.computeRedundancy(model.computeRedundancy);
        }

        public final String getDbShardGroupIdentifier() {
            return this.dbShardGroupIdentifier;
        }

        public final void setDbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
        }

        @Override
        public final Builder dbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
            return this;
        }

        public final Double getMaxACU() {
            return this.maxACU;
        }

        public final void setMaxACU(Double maxACU) {
            this.maxACU = maxACU;
        }

        @Override
        public final Builder maxACU(Double maxACU) {
            this.maxACU = maxACU;
            return this;
        }

        public final Double getMinACU() {
            return this.minACU;
        }

        public final void setMinACU(Double minACU) {
            this.minACU = minACU;
        }

        @Override
        public final Builder minACU(Double minACU) {
            this.minACU = minACU;
            return this;
        }

        public final Integer getComputeRedundancy() {
            return this.computeRedundancy;
        }

        public final void setComputeRedundancy(Integer computeRedundancy) {
            this.computeRedundancy = computeRedundancy;
        }

        @Override
        public final Builder computeRedundancy(Integer computeRedundancy) {
            this.computeRedundancy = computeRedundancy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbShardGroupRequest build() {
            return new ModifyDbShardGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbShardGroupRequest> {
        public Builder dbShardGroupIdentifier(String var1);

        public Builder maxACU(Double var1);

        public Builder minACU(Double var1);

        public Builder computeRedundancy(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

