/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.services.rds.model.TenantDatabase;
import software.amazon.awssdk.services.rds.model.TenantDatabasesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTenantDatabasesResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeTenantDatabasesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeTenantDatabasesResponse.getter(DescribeTenantDatabasesResponse::marker)).setter(DescribeTenantDatabasesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<TenantDatabase>> TENANT_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TenantDatabases").getter(DescribeTenantDatabasesResponse.getter(DescribeTenantDatabasesResponse::tenantDatabases)).setter(DescribeTenantDatabasesResponse.setter(Builder::tenantDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDatabases").build(), ListTrait.builder().memberLocationName("TenantDatabase").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TenantDatabase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDatabase").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, TENANT_DATABASES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTenantDatabasesResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<TenantDatabase> tenantDatabases;

    private DescribeTenantDatabasesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.tenantDatabases = builder.tenantDatabases;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasTenantDatabases() {
        return this.tenantDatabases != null && !(this.tenantDatabases instanceof SdkAutoConstructList);
    }

    public final List<TenantDatabase> tenantDatabases() {
        return this.tenantDatabases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTenantDatabases() ? this.tenantDatabases() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTenantDatabasesResponse)) {
            return false;
        }
        DescribeTenantDatabasesResponse other = (DescribeTenantDatabasesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasTenantDatabases() == other.hasTenantDatabases() && Objects.equals(this.tenantDatabases(), other.tenantDatabases());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTenantDatabasesResponse").add("Marker", (Object)this.marker()).add("TenantDatabases", this.hasTenantDatabases() ? this.tenantDatabases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "TenantDatabases": {
                return Optional.ofNullable(clazz.cast(this.tenantDatabases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("TenantDatabases", TENANT_DATABASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTenantDatabasesResponse, T> g) {
        return obj -> g.apply((DescribeTenantDatabasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<TenantDatabase> tenantDatabases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTenantDatabasesResponse model) {
            super(model);
            this.marker(model.marker);
            this.tenantDatabases(model.tenantDatabases);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<TenantDatabase.Builder> getTenantDatabases() {
            List<TenantDatabase.Builder> result = TenantDatabasesListCopier.copyToBuilder(this.tenantDatabases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTenantDatabases(Collection<TenantDatabase.BuilderImpl> tenantDatabases) {
            this.tenantDatabases = TenantDatabasesListCopier.copyFromBuilder(tenantDatabases);
        }

        @Override
        public final Builder tenantDatabases(Collection<TenantDatabase> tenantDatabases) {
            this.tenantDatabases = TenantDatabasesListCopier.copy(tenantDatabases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenantDatabases(TenantDatabase ... tenantDatabases) {
            this.tenantDatabases(Arrays.asList(tenantDatabases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenantDatabases(Consumer<TenantDatabase.Builder> ... tenantDatabases) {
            this.tenantDatabases(Stream.of(tenantDatabases).map(c -> (TenantDatabase)((TenantDatabase.Builder)TenantDatabase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeTenantDatabasesResponse build() {
            return new DescribeTenantDatabasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTenantDatabasesResponse> {
        public Builder marker(String var1);

        public Builder tenantDatabases(Collection<TenantDatabase> var1);

        public Builder tenantDatabases(TenantDatabase ... var1);

        public Builder tenantDatabases(Consumer<TenantDatabase.Builder> ... var1);
    }
}

