/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DBSnapshotTenantDatabase;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesResponse;

public class DescribeDBSnapshotTenantDatabasesIterable
implements SdkIterable<DescribeDbSnapshotTenantDatabasesResponse> {
    private final RdsClient client;
    private final DescribeDbSnapshotTenantDatabasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBSnapshotTenantDatabasesIterable(RdsClient client, DescribeDbSnapshotTenantDatabasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDbSnapshotTenantDatabasesResponseFetcher();
    }

    public Iterator<DescribeDbSnapshotTenantDatabasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBSnapshotTenantDatabase> dbSnapshotTenantDatabases() {
        Function<DescribeDbSnapshotTenantDatabasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSnapshotTenantDatabases() != null) {
                return response.dbSnapshotTenantDatabases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbSnapshotTenantDatabasesResponseFetcher
    implements SyncPageFetcher<DescribeDbSnapshotTenantDatabasesResponse> {
        private DescribeDbSnapshotTenantDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbSnapshotTenantDatabasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbSnapshotTenantDatabasesResponse nextPage(DescribeDbSnapshotTenantDatabasesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSnapshotTenantDatabasesIterable.this.client.describeDBSnapshotTenantDatabases(DescribeDBSnapshotTenantDatabasesIterable.this.firstRequest);
            }
            return DescribeDBSnapshotTenantDatabasesIterable.this.client.describeDBSnapshotTenantDatabases((DescribeDbSnapshotTenantDatabasesRequest)((Object)DescribeDBSnapshotTenantDatabasesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

