/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Range
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Range> {
    private static final SdkField<Integer> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("From").getter(Range.getter(Range::from)).setter(Range.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()}).build();
    private static final SdkField<Integer> TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("To").getter(Range.getter(Range::to)).setter(Range.setter(Builder::to)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("To").build()}).build();
    private static final SdkField<Integer> STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Step").getter(Range.getter(Range::step)).setter(Range.setter(Builder::step)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Step").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, TO_FIELD, STEP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Range.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer from;
    private final Integer to;
    private final Integer step;

    private Range(BuilderImpl builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.step = builder.step;
    }

    public final Integer from() {
        return this.from;
    }

    public final Integer to() {
        return this.to;
    }

    public final Integer step() {
        return this.step;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.to());
        hashCode = 31 * hashCode + Objects.hashCode(this.step());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.from(), other.from()) && Objects.equals(this.to(), other.to()) && Objects.equals(this.step(), other.step());
    }

    public final String toString() {
        return ToString.builder((String)"Range").add("From", (Object)this.from()).add("To", (Object)this.to()).add("Step", (Object)this.step()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "From": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
            case "To": {
                return Optional.ofNullable(clazz.cast(this.to()));
            }
            case "Step": {
                return Optional.ofNullable(clazz.cast(this.step()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("From", FROM_FIELD);
        map.put("To", TO_FIELD);
        map.put("Step", STEP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Range, T> g) {
        return obj -> g.apply((Range)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer from;
        private Integer to;
        private Integer step;

        private BuilderImpl() {
        }

        private BuilderImpl(Range model) {
            this.from(model.from);
            this.to(model.to);
            this.step(model.step);
        }

        public final Integer getFrom() {
            return this.from;
        }

        public final void setFrom(Integer from) {
            this.from = from;
        }

        @Override
        public final Builder from(Integer from) {
            this.from = from;
            return this;
        }

        public final Integer getTo() {
            return this.to;
        }

        public final void setTo(Integer to) {
            this.to = to;
        }

        @Override
        public final Builder to(Integer to) {
            this.to = to;
            return this;
        }

        public final Integer getStep() {
            return this.step;
        }

        public final void setStep(Integer step) {
            this.step = step;
        }

        @Override
        public final Builder step(Integer step) {
            this.step = step;
            return this;
        }

        public Range build() {
            return new Range(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Range> {
        public Builder from(Integer var1);

        public Builder to(Integer var1);

        public Builder step(Integer var1);
    }
}

