/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse;
import software.amazon.awssdk.services.rds.model.SourceRegion;

public class DescribeSourceRegionsPublisher
implements SdkPublisher<DescribeSourceRegionsResponse> {
    private final RdsAsyncClient client;
    private final DescribeSourceRegionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSourceRegionsPublisher(RdsAsyncClient client, DescribeSourceRegionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSourceRegionsPublisher(RdsAsyncClient client, DescribeSourceRegionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSourceRegionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSourceRegionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SourceRegion> sourceRegions() {
        Function<DescribeSourceRegionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sourceRegions() != null) {
                return response.sourceRegions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSourceRegionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSourceRegionsResponseFetcher
    implements AsyncPageFetcher<DescribeSourceRegionsResponse> {
        private DescribeSourceRegionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSourceRegionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeSourceRegionsResponse> nextPage(DescribeSourceRegionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSourceRegionsPublisher.this.client.describeSourceRegions(DescribeSourceRegionsPublisher.this.firstRequest);
            }
            return DescribeSourceRegionsPublisher.this.client.describeSourceRegions((DescribeSourceRegionsRequest)((Object)DescribeSourceRegionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

