/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDbInstanceResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, StartDbInstanceResponse> {
    private static final SdkField<DBInstance> DB_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartDbInstanceResponse.getter(StartDbInstanceResponse::dbInstance)).setter(StartDbInstanceResponse.setter(Builder::dbInstance)).constructor(DBInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_FIELD));
    private final DBInstance dbInstance;

    private StartDbInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.dbInstance = builder.dbInstance;
    }

    public DBInstance dbInstance() {
        return this.dbInstance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstance());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDbInstanceResponse)) {
            return false;
        }
        StartDbInstanceResponse other = (StartDbInstanceResponse)((Object)obj);
        return Objects.equals(this.dbInstance(), other.dbInstance());
    }

    public String toString() {
        return ToString.builder((String)"StartDbInstanceResponse").add("DBInstance", (Object)this.dbInstance()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstance": {
                return Optional.ofNullable(clazz.cast(this.dbInstance()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDbInstanceResponse, T> g) {
        return obj -> g.apply((StartDbInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private DBInstance dbInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDbInstanceResponse model) {
            super(model);
            this.dbInstance(model.dbInstance);
        }

        public final DBInstance.Builder getDBInstance() {
            return this.dbInstance != null ? this.dbInstance.toBuilder() : null;
        }

        @Override
        public final Builder dbInstance(DBInstance dbInstance) {
            this.dbInstance = dbInstance;
            return this;
        }

        public final void setDBInstance(DBInstance.BuilderImpl dbInstance) {
            this.dbInstance = dbInstance != null ? dbInstance.build() : null;
        }

        @Override
        public StartDbInstanceResponse build() {
            return new StartDbInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDbInstanceResponse> {
        public Builder dbInstance(DBInstance var1);

        default public Builder dbInstance(Consumer<DBInstance.Builder> dbInstance) {
            return this.dbInstance((DBInstance)((DBInstance.Builder)DBInstance.builder().applyMutation(dbInstance)).build());
        }
    }
}

