/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBEngineVersion;
import software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse;

public class DescribeDBEngineVersionsIterable
implements SdkIterable<DescribeDbEngineVersionsResponse> {
    private final RdsClient client;
    private final DescribeDbEngineVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBEngineVersionsIterable(RdsClient client, DescribeDbEngineVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbEngineVersionsResponseFetcher();
    }

    public Iterator<DescribeDbEngineVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBEngineVersion> dbEngineVersions() {
        Function<DescribeDbEngineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbEngineVersions() != null) {
                return response.dbEngineVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbEngineVersionsResponseFetcher
    implements SyncPageFetcher<DescribeDbEngineVersionsResponse> {
        private DescribeDbEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbEngineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbEngineVersionsResponse nextPage(DescribeDbEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBEngineVersionsIterable.this.client.describeDBEngineVersions(DescribeDBEngineVersionsIterable.this.firstRequest);
            }
            return DescribeDBEngineVersionsIterable.this.client.describeDBEngineVersions((DescribeDbEngineVersionsRequest)((Object)DescribeDBEngineVersionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

