/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.ScalingConfiguration;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreDbClusterFromSnapshotRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, RestoreDbClusterFromSnapshotRequest> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::availabilityZones)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName("AvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::dbClusterIdentifier)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotIdentifier").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::snapshotIdentifier)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::snapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::engine)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::engineVersion)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::port)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSubnetGroupName").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::dbSubnetGroupName)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::dbSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::databaseName)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::optionGroupName)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::vpcSecurityGroupIds)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::tags)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::kmsKeyId)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableIAMDatabaseAuthentication").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::enableIAMDatabaseAuthentication)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::enableIAMDatabaseAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication").build()}).build();
    private static final SdkField<Long> BACKTRACK_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BacktrackWindow").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::backtrackWindow)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::backtrackWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackWindow").build()}).build();
    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnableCloudwatchLogsExports").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::enableCloudwatchLogsExports)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::enableCloudwatchLogsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENGINE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineMode").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::engineMode)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::engineMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineMode").build()}).build();
    private static final SdkField<ScalingConfiguration> SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScalingConfiguration").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::scalingConfiguration)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::scalingConfiguration)).constructor(ScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingConfiguration").build()}).build();
    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterParameterGroupName").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::dbClusterParameterGroupName)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::dbClusterParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::deletionProtection)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshot").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::copyTagsToSnapshot)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::domain)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainIAMRoleName").getter(RestoreDbClusterFromSnapshotRequest.getter(RestoreDbClusterFromSnapshotRequest::domainIAMRoleName)).setter(RestoreDbClusterFromSnapshotRequest.setter(Builder::domainIAMRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_IDENTIFIER_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, PORT_FIELD, DB_SUBNET_GROUP_NAME_FIELD, DATABASE_NAME_FIELD, OPTION_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, BACKTRACK_WINDOW_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, ENGINE_MODE_FIELD, SCALING_CONFIGURATION_FIELD, DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, DELETION_PROTECTION_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, DOMAIN_FIELD, DOMAIN_IAM_ROLE_NAME_FIELD));
    private final List<String> availabilityZones;
    private final String dbClusterIdentifier;
    private final String snapshotIdentifier;
    private final String engine;
    private final String engineVersion;
    private final Integer port;
    private final String dbSubnetGroupName;
    private final String databaseName;
    private final String optionGroupName;
    private final List<String> vpcSecurityGroupIds;
    private final List<Tag> tags;
    private final String kmsKeyId;
    private final Boolean enableIAMDatabaseAuthentication;
    private final Long backtrackWindow;
    private final List<String> enableCloudwatchLogsExports;
    private final String engineMode;
    private final ScalingConfiguration scalingConfiguration;
    private final String dbClusterParameterGroupName;
    private final Boolean deletionProtection;
    private final Boolean copyTagsToSnapshot;
    private final String domain;
    private final String domainIAMRoleName;

    private RestoreDbClusterFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.databaseName = builder.databaseName;
        this.optionGroupName = builder.optionGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.backtrackWindow = builder.backtrackWindow;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.engineMode = builder.engineMode;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.deletionProtection = builder.deletionProtection;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Integer port() {
        return this.port;
    }

    public final String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String optionGroupName() {
        return this.optionGroupName;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public final Long backtrackWindow() {
        return this.backtrackWindow;
    }

    public final boolean hasEnableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports != null && !(this.enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    public final List<String> enableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports;
    }

    public final String engineMode() {
        return this.engineMode;
    }

    public final ScalingConfiguration scalingConfiguration() {
        return this.scalingConfiguration;
    }

    public final String dbClusterParameterGroupName() {
        return this.dbClusterParameterGroupName;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainIAMRoleName() {
        return this.domainIAMRoleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.engineMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIAMRoleName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbClusterFromSnapshotRequest)) {
            return false;
        }
        RestoreDbClusterFromSnapshotRequest other = (RestoreDbClusterFromSnapshotRequest)((Object)obj);
        return this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication()) && Objects.equals(this.backtrackWindow(), other.backtrackWindow()) && this.hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports() && Objects.equals(this.enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports()) && Objects.equals(this.engineMode(), other.engineMode()) && Objects.equals(this.scalingConfiguration(), other.scalingConfiguration()) && Objects.equals(this.dbClusterParameterGroupName(), other.dbClusterParameterGroupName()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainIAMRoleName(), other.domainIAMRoleName());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreDbClusterFromSnapshotRequest").add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("SnapshotIdentifier", (Object)this.snapshotIdentifier()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("Port", (Object)this.port()).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("DatabaseName", (Object)this.databaseName()).add("OptionGroupName", (Object)this.optionGroupName()).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("KmsKeyId", (Object)this.kmsKeyId()).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).add("BacktrackWindow", (Object)this.backtrackWindow()).add("EnableCloudwatchLogsExports", this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null).add("EngineMode", (Object)this.engineMode()).add("ScalingConfiguration", (Object)this.scalingConfiguration()).add("DBClusterParameterGroupName", (Object)this.dbClusterParameterGroupName()).add("DeletionProtection", (Object)this.deletionProtection()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("Domain", (Object)this.domain()).add("DomainIAMRoleName", (Object)this.domainIAMRoleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "SnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotIdentifier()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
            case "BacktrackWindow": {
                return Optional.ofNullable(clazz.cast(this.backtrackWindow()));
            }
            case "EnableCloudwatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enableCloudwatchLogsExports()));
            }
            case "EngineMode": {
                return Optional.ofNullable(clazz.cast(this.engineMode()));
            }
            case "ScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scalingConfiguration()));
            }
            case "DBClusterParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbClusterParameterGroupName()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "DomainIAMRoleName": {
                return Optional.ofNullable(clazz.cast(this.domainIAMRoleName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreDbClusterFromSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreDbClusterFromSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String dbClusterIdentifier;
        private String snapshotIdentifier;
        private String engine;
        private String engineVersion;
        private Integer port;
        private String dbSubnetGroupName;
        private String databaseName;
        private String optionGroupName;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;
        private Boolean enableIAMDatabaseAuthentication;
        private Long backtrackWindow;
        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();
        private String engineMode;
        private ScalingConfiguration scalingConfiguration;
        private String dbClusterParameterGroupName;
        private Boolean deletionProtection;
        private Boolean copyTagsToSnapshot;
        private String domain;
        private String domainIAMRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbClusterFromSnapshotRequest model) {
            super(model);
            this.availabilityZones(model.availabilityZones);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.port(model.port);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.databaseName(model.databaseName);
            this.optionGroupName(model.optionGroupName);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.tags(model.tags);
            this.kmsKeyId(model.kmsKeyId);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            this.backtrackWindow(model.backtrackWindow);
            this.enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            this.engineMode(model.engineMode);
            this.scalingConfiguration(model.scalingConfiguration);
            this.dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            this.deletionProtection(model.deletionProtection);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.domain(model.domain);
            this.domainIAMRoleName(model.domainIAMRoleName);
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final Long getBacktrackWindow() {
            return this.backtrackWindow;
        }

        @Override
        public final Builder backtrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public final void setBacktrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (this.enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enableCloudwatchLogsExports;
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String ... enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        public final String getEngineMode() {
            return this.engineMode;
        }

        @Override
        public final Builder engineMode(String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        public final void setEngineMode(String engineMode) {
            this.engineMode = engineMode;
        }

        public final ScalingConfiguration.Builder getScalingConfiguration() {
            return this.scalingConfiguration != null ? this.scalingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfiguration scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final void setScalingConfiguration(ScalingConfiguration.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        public final String getDbClusterParameterGroupName() {
            return this.dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainIAMRoleName() {
            return this.domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbClusterFromSnapshotRequest build() {
            return new RestoreDbClusterFromSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreDbClusterFromSnapshotRequest> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder snapshotIdentifier(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder port(Integer var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder databaseName(String var1);

        public Builder optionGroupName(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder kmsKeyId(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder backtrackWindow(Long var1);

        public Builder enableCloudwatchLogsExports(Collection<String> var1);

        public Builder enableCloudwatchLogsExports(String ... var1);

        public Builder engineMode(String var1);

        public Builder scalingConfiguration(ScalingConfiguration var1);

        default public Builder scalingConfiguration(Consumer<ScalingConfiguration.Builder> scalingConfiguration) {
            return this.scalingConfiguration((ScalingConfiguration)((ScalingConfiguration.Builder)ScalingConfiguration.builder().applyMutation(scalingConfiguration)).build());
        }

        public Builder dbClusterParameterGroupName(String var1);

        public Builder deletionProtection(Boolean var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder domain(String var1);

        public Builder domainIAMRoleName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

