/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse;
import software.amazon.awssdk.services.rds.model.OptionGroup;

public class DescribeOptionGroupsPublisher
implements SdkPublisher<DescribeOptionGroupsResponse> {
    private final RdsAsyncClient client;
    private final DescribeOptionGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOptionGroupsPublisher(RdsAsyncClient client, DescribeOptionGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOptionGroupsPublisher(RdsAsyncClient client, DescribeOptionGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOptionGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOptionGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OptionGroup> optionGroupsList() {
        Function<DescribeOptionGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.optionGroupsList() != null) {
                return response.optionGroupsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeOptionGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeOptionGroupsPublisher resume(DescribeOptionGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeOptionGroupsPublisher(this.client, (DescribeOptionGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeOptionGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeOptionGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeOptionGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeOptionGroupsResponse> {
        private DescribeOptionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOptionGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeOptionGroupsResponse> nextPage(DescribeOptionGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOptionGroupsPublisher.this.client.describeOptionGroups(DescribeOptionGroupsPublisher.this.firstRequest);
            }
            return DescribeOptionGroupsPublisher.this.client.describeOptionGroups((DescribeOptionGroupsRequest)((Object)DescribeOptionGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

